/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.commonj.usequeue;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.standard.StandardWorkQueue;

import commonj.work.WorkItem;
import commonj.work.WorkManager;

/**
 * <code>WorkQueue</code> C^tF[XCommonjpNXB
 * 
 * <p>
 * ̎ł́AJDK <code>BLockingQueue</code> ɂăL[COB
 * </p>
 * 
 * <p>
 * L[ւ̗vfǉAL[̗vf擾̍ۂɂ́AubN̂ł͂ȂA
 * ^CAEgԂsƂ<code>JobStatus</code> `FbN 
 * <code>QueueingException</code> OX[B 
 * L[ւ̗vfǉAL[̗vf擾̍ۂɁAXbhC^vgꂽ
 * ۂɂ<code>QueueingException</code> OX[B
 * </p>
 * 
 */
public class WorkManagerTaskWorkQueue extends StandardWorkQueue {

    /**
     * L[̗vf̏ʂ̃XgB
     */
    private List<WorkItem> workItemList = new ArrayList<WorkItem>();

    /**
     * [N}l[WB
     */
    private WorkManager workManager = null;

    /**
     * WuJn܂ł̃^CAEgi~bjB
     */
    private long workTimeout = WorkManager.INDEFINITE;

    /**
     * RXgN^B
     * 
     * @param queueLength L[̒
     * @param jobStatus WuXe[^X
     */
    public WorkManagerTaskWorkQueue(int queueLength, JobStatus jobStatus) {
        super(queueLength, jobStatus);
    }

    /**
     * L[̗vf邷ׂẴ[J̏I҂킹B
     */
    @Override
    public void waitForAllWorkers() {
        try {
            workManager.waitForAll(workItemList, workTimeout);
        } catch (IllegalArgumentException e) {
            throw new JobException(e);
        } catch (InterruptedException e) {
            throw new JobException(e);
        }
    }

    /**
     * [J̏ʂɔ񓯊ŃANZX߂WorkItemǉB
     * 
     * @param workItem [J̏ʂɔ񓯊ŃANZX߂WorkItem
     */
    public void addWorkItem(WorkItem workItem) {
        workItemList.add(workItem);
    }

    /**
     * [N}l[Wݒ肷B
     * 
     * @param workManager workManager [N}l[W
     */
    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    /**
     * WuJn܂ł̃^CAEgi~bj̐ݒB
     * 
     * @param workTimeout ^CAEgi~bj
     */
    public void setWorkTimeout(long workTimeout) {
        this.workTimeout = workTimeout;
    }

    /**
     * ʂɔ񓯊ŃANZX߂̃t[`[ǉB
     * ̃NXł͎gpȂ߁AUnsupportedOperationExceptionX[B
     *  
     * @param futureResult ʂɔ񓯊ŃANZXt[`[
     */
    @Override
    public void addFutureJobResult(Future< ? > futureResult) {
        throw new UnsupportedOperationException();
    }

}
