/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.standard;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/**
 * Xbhv[̃TCY𐶐NXB
 * Wȗdx~QXbhv[TCYƂĕԂB
 * 
 */
public class ThreadSizeFactoryBean implements FactoryBean, InitializingBean {

    /**
     * dx
     */
    private int multiplicity = 0;

    /**
     * XbhB
     */
    private Integer threadSize = null;

    /**
     * <code>FactoryBean</code>̎B
     * Xbh̃CX^XԂB
     * 
     * @return Xbh
     */
    public Object getObject() {
        return this.threadSize;
    }

    /**
     * <code>FactoryBean</code>̎B
     * <code>FactoryBean</code>琶CX^X̃^CvB
     * 
     * @return Integer.class
     */
    public Class getObjectType() {
        return Integer.class;
    }

    /**
     * <code>FactoryBean</code>̎B
     * <code>Singleton</code>ł邩]B
     * 
     * @return <code>true</code>
     */
    public boolean isSingleton() {
        return true;
    }

    /**
     * dxݒ肷B
     * 
     * @param multiplicity dx
     */
    public void setMultiplicity(int multiplicity) {
        this.multiplicity = multiplicity;
    }

    /**
     * <code>InitializingBean</code>̎B
     * CX^X쐬̏sB
     * dx~Q<code>threadSize</code>ɐݒ肷B
     * 
     */
    public void afterPropertiesSet() {
//        this.threadSize = new Integer(multiplicity * 2);
        this.threadSize = Integer.valueOf(multiplicity * 2);
    }

}
