/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.sample008;

import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.ControlBreakHandler;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;

/**
 * Rg[uCNnh̎NXB
 */
public class Sample008ChunkControlBreakHandler implements ControlBreakHandler {

    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(Sample008TransControlBreakHandler.class);
    
    public BLogicResult handleControlBreak(Map breakKeyValueMap, JobContext jobContext) {
    
    if(log.isInfoEnabled()){
        Set keyset = breakKeyValueMap.keySet();
        for(Object key : keyset){
        log.info("Key:" + key + " Value:" + breakKeyValueMap.get(key));
        }
        
    }
    
    return new BLogicResult(ReturnCode.NORMAL_CONTINUE);
    }

}
