/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.handler;

import java.util.HashMap;
import java.util.Map;

import org.springframework.web.servlet.HandlerExecutionChain;

import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ErrorPageHandlerMapping;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ErrorPageHandlerMapping} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * NGXgێO̗LɂăRg[ԂnhB<br>
 * OF
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ErrorPageHandlerMapping
 */
public class ErrorPageHandlerMappingTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ErrorPageHandlerMappingTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ErrorPageHandlerMappingTest(String name) {
        super(name);
    }

    /**
     * testGetBeanId01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.beanId:"/testController"<br>
     *         
     * <br>
     * ҒlF(߂l) -:"/testController"<br>
     *         
     * <br>
     * beanIdget\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetBeanId01() throws Exception {
        // O
        ErrorPageHandlerMapping hm = new ErrorPageHandlerMapping();
        UTUtil.setPrivateField(hm, "beanId", "/testController");

        // eXg{
        assertEquals("/testController", hm.getBeanId());
    }

    /**
     * testSetBeanId01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() beanId:"/testController"<br>
     *         () this.beanId:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.beanId:"/testController"<br>
     *         
     * <br>
     * beanIdset\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetBeanId01() throws Exception {
        // O
        ErrorPageHandlerMapping hm = new ErrorPageHandlerMapping();

        // eXg{
        hm.setBeanId("/testController");

        // 
        assertEquals("/testController", UTUtil.getPrivateField(hm, "beanId"));
    }

    /**
     * testGetHandlerInternal01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:not null<br>
     *                (javax.servlet.error.exception={ExceptionIuWFNg}j<br>
     *         () this.handlerMap:Map{<br>
     *                  "/exceptionController"=IuWFNg<br>
     *                }<br>
     *         
     * <br>
     * ҒlF(߂l) Object:this.handlerMapŕێĂIuWFNg<br>
     *         
     * <br>
     * NGXgŗOێĂ߁A<br>
     * OpRg[Ԃp^[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetHandlerInternal01() throws Exception {
        // O
        ErrorPageHandlerMapping hm = new ErrorPageHandlerMapping();
        
        // nh}bsÕvpeB
        Map handlerMap = new HashMap();
        Object object = new Object();
        handlerMap.put("/exceptionController", object);
        UTUtil.setPrivateField(hm, "handlerMap", handlerMap);
        
        // NGXg
        Exception exception = new Exception();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("javax.servlet.error.exception", exception);

        // eXg{
        Object handler = hm.getHandlerInternal(request);
        
        assertTrue(handler instanceof HandlerExecutionChain);
        assertSame(object, ((HandlerExecutionChain) handler).getHandler());
    }

    /**
     * testGetHandlerInternal02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:not null<br>
     *                (javax.servlet.error.exception={ExceptionIuWFNg}j<br>
     *         () this.handlerMap:Map{}<br>
     *         
     * <br>
     * ҒlF(߂l) Object:null<br>
     *         
     * <br>
     * NGXgŗOێĂA<br>
     * OpRg[Ȃp^[B<br>
     * NullԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetHandlerInternal02() throws Exception {
        // O
        ErrorPageHandlerMapping hm = new ErrorPageHandlerMapping();
        
        // NGXg
        Exception exception = new Exception();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setAttribute("javax.servlet.error.exception", exception);

        // eXg{
        assertNull(hm.getHandlerInternal(request));
    }

    /**
     * testGetHandlerInternal03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:not null<br>
     *         () this.handlerMap:Map{
     *         "/exceptionController"=IuWFNg}<br>
     *         
     * <br>
     * ҒlF(߂l) Object:null<br>
     *         
     * <br>
     * NGXgŗOĂȂp^[BNullԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetHandlerInternal03() throws Exception {
        // O
        ErrorPageHandlerMapping hm = new ErrorPageHandlerMapping();
        
        // nh}bsÕvpeB
        Map handlerMap = new HashMap();
        Object object = new Object();
        handlerMap.put("/exceptionController", object);
        UTUtil.setPrivateField(hm, "handlerMap", handlerMap);
        
        // NGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        assertNull(hm.getHandlerInternal(request));
    }

}
