/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.handler;

import java.util.HashMap;
import java.util.Map;

import org.springframework.web.servlet.HandlerExecutionChain;

import jp.terasoluna.fw.web.rich.context.support.DefaultRequestContextSupportImpl;
import jp.terasoluna.fw.web.rich.context.support.RequestContextSupport;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.fw.web.rich.springmvc.servlet.handler.BeanNameUrlHandlerMappingEx;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.servlet.handler.
 * BeanNameUrlHandlerMappingEx} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * NGXgƎs郊NGXgRg[Bean`̃}bsO
 * snhB<br>
 * OFBean`t@CɃRg[`ĂKvB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.handler.
 * BeanNameUrlHandlerMappingEx
 */
public class BeanNameUrlHandlerMappingExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BeanNameUrlHandlerMappingExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BeanNameUrlHandlerMappingExTest(String name) {
        super(name);
    }

    /**
     * testSetPrefix01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() prefix:not null<br>
     *                ih/hj<br>
     *         () this.prefix:not null<br>
     *                ihhj<br>
     *         
     * <br>
     * ҒlF(ԕω) prefix:Őݒ肵lݒ肳ĂB<br>
     *         
     * <br>
     * prefixset\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetPrefix01() throws Exception {
        // O
        BeanNameUrlHandlerMappingEx handlerMapping = 
            new BeanNameUrlHandlerMappingEx();
        UTUtil.setPrivateField(handlerMapping, "prefix", null);

        // eXg{
        String value = "/";
        handlerMapping.setPrefix(value);

        // 
        Object result = UTUtil.getPrivateField(handlerMapping, "prefix");
        assertEquals(value, result);
    }

    /**
     * testSetSuffix01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() suffix:not null<br>
     *                ihControllerhj<br>
     *         () this.suffix:not null<br>
     *                ihhj<br>
     *         
     * <br>
     * ҒlF(ԕω) suffix:Őݒ肵lݒ肳ĂB<br>
     *         
     * <br>
     * suffixset\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetSuffix01() throws Exception {
        // O
        BeanNameUrlHandlerMappingEx handlerMapping = 
            new BeanNameUrlHandlerMappingEx();
        UTUtil.setPrivateField(handlerMapping, "suffix", null);

        // eXg{
        String value = "Controller";
        handlerMapping.setSuffix(value);

        // 
        Object result = UTUtil.getPrivateField(handlerMapping, "suffix");
        assertEquals(value, result);
    }

    /**
     * testSetCtxSupport01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ctxSupport:not null<br>
     *         () this.ctxSupport:null<br>
     *         
     * <br>
     * ҒlF(ԕω) ctxSupport:Őݒ肵lݒ肳ĂB<br>
     *         
     * <br>
     * ctxSupportset\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetCtxSupport01() throws Exception {
        // O
        BeanNameUrlHandlerMappingEx handlerMapping = 
            new BeanNameUrlHandlerMappingEx();
        UTUtil.setPrivateField(handlerMapping, "ctxSupport", null);

        // eXg{
        RequestContextSupport ctxSupport = 
            new DefaultRequestContextSupportImpl();
        handlerMapping.setCtxSupport(ctxSupport);

        // 
        Object result = UTUtil.getPrivateField(handlerMapping, "ctxSupport");
        assertSame(ctxSupport, result);
    }

    /**
     * testLookupHandler01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ctxSupport.getRequestName():"sum"<br>
     *         () prefix:"/"<br>
     *         () suffix:"Controller"<br>
     *         
     * <br>
     * ҒlF(߂l) Object:super.lookupHandlerij̖߂lƓƂ
     *         mFB<br>
     *         (ԕω) super.lookupHandlerij:
     *         ĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * Rg[擾\bh̃eXgB
     * vtBbNXETtBbNXgpăRg[IDw肷B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupHandler01() throws Exception {
        // O
        BeanNameUrlHandlerMappingEx handlerMapping = 
            new BeanNameUrlHandlerMappingEx();
        Object dummy = new Object();
        Map<Object, Object> handlerMap = new HashMap<Object, Object>();
        handlerMap.put("/sumController", dummy);
        UTUtil.setPrivateField(handlerMapping, "handlerMap", handlerMap);
        String prefix = "/";
        UTUtil.setPrivateField(handlerMapping, "prefix", prefix);
        String suffix = "Controller";
        UTUtil.setPrivateField(handlerMapping, "suffix", suffix);
        BeanNameUrlHandlerMappingEx_DefaultRequestContextSupportImplStub01 ctxSupport = 
            new BeanNameUrlHandlerMappingEx_DefaultRequestContextSupportImplStub01();
        ctxSupport.setRequestName("sum");
        UTUtil.setPrivateField(handlerMapping, "ctxSupport", ctxSupport); 
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        Object result = handlerMapping.lookupHandler(null, request);

        // 
        assertTrue(result instanceof HandlerExecutionChain);
        assertSame(dummy, ((HandlerExecutionChain) result).getHandler());
    }

    /**
     * testLookupHandler02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ctxSupport.getRequestName():null<br>
     *         () prefix:null<br>
     *         () suffix:null<br>
     *         
     * <br>
     * ҒlF(߂l) Object:super.lookupHandlerij̖߂lƓƂ
     *         mFB<br>
     *         (ԕω) super.lookupHandlerij:
     *         ĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * Rg[擾\bh̃eXgBNGXgNull̏ꍇ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupHandler02() throws Exception {
        // O
        BeanNameUrlHandlerMappingEx handlerMapping = 
            new BeanNameUrlHandlerMappingEx();
        Object dummy = new Object();
        Map<Object, Object> handlerMap = new HashMap<Object, Object>();
        handlerMap.put("/nullController", dummy);
        UTUtil.setPrivateField(handlerMapping, "handlerMap", handlerMap);
        String prefix = "/";
        UTUtil.setPrivateField(handlerMapping, "prefix", prefix);
        String suffix = "Controller";
        UTUtil.setPrivateField(handlerMapping, "suffix", suffix);
        BeanNameUrlHandlerMappingEx_DefaultRequestContextSupportImplStub01 ctxSupport = 
            new BeanNameUrlHandlerMappingEx_DefaultRequestContextSupportImplStub01();
        ctxSupport.setRequestName(null);
        UTUtil.setPrivateField(handlerMapping, "ctxSupport", ctxSupport);
        
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        Object result = handlerMapping.lookupHandler(null, request);

        // 
        assertTrue(result instanceof HandlerExecutionChain);
        assertSame(dummy, ((HandlerExecutionChain) result).getHandler());
    }

    /**
     * testLookupHandler03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ctxSupport.getRequestName()P:󕶎<br>
     *         () prefix:󕶎<br>
     *         () suffix:󕶎<br>
     *         
     * <br>
     * ҒlF(߂l) Object:super.lookupHandlerij̖߂lƓƂ
     *         mFB<br>
     *         (ԕω) super.lookupHandlerij:
     *         ĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * Rg[擾\bh̃eXgBNGXg󕶎̏ꍇ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupHandler03() throws Exception {
        // O
        BeanNameUrlHandlerMappingEx handlerMapping = 
            new BeanNameUrlHandlerMappingEx();
        Object dummy = new Object();
        Map<Object, Object> handlerMap = new HashMap<Object, Object>();
        handlerMap.put("/Controller", dummy);
        UTUtil.setPrivateField(handlerMapping, "handlerMap", handlerMap);
        String prefix = "/";
        UTUtil.setPrivateField(handlerMapping, "prefix", prefix);
        String suffix = "Controller";
        UTUtil.setPrivateField(handlerMapping, "suffix", suffix);
        BeanNameUrlHandlerMappingEx_DefaultRequestContextSupportImplStub01 ctxSupport = 
            new BeanNameUrlHandlerMappingEx_DefaultRequestContextSupportImplStub01();
        ctxSupport.setRequestName("");
        UTUtil.setPrivateField(handlerMapping, "ctxSupport", ctxSupport);
        
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        Object result = handlerMapping.lookupHandler(null, request);

        // 
        assertTrue(result instanceof HandlerExecutionChain);
        assertSame(dummy, ((HandlerExecutionChain) result).getHandler()); 
    }

    /**
     * testLookupHandler04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ctxSupport.getRequestName()P:"sum"<br>
     *         () prefix:"/"<br>
     *         () suffix:"Controller"<br>
     *         
     * <br>
     * ҒlF(߂l) Object:Null<br>
     *         (ԕω) super.lookupHandlerij:ĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         (ԕω) O:OxFG[<br>
     *                    "Controller is not found. " + "BeanName:'" + newUrlPath + "'"<br>
     *         
     * <br>
     * w肵Rg[Ȃꍇ̃eXgBNullԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupHandler04() throws Exception {
        // O
        BeanNameUrlHandlerMappingEx handlerMapping = 
            new BeanNameUrlHandlerMappingEx();
        Map<Object, Object> handlerMap = new HashMap<Object, Object>();
        UTUtil.setPrivateField(handlerMapping, "handlerMap", handlerMap);
        String prefix = "/";
        UTUtil.setPrivateField(handlerMapping, "prefix", prefix);
        String suffix = "Controller";
        UTUtil.setPrivateField(handlerMapping, "suffix", suffix);
        BeanNameUrlHandlerMappingEx_DefaultRequestContextSupportImplStub01 ctxSupport = 
            new BeanNameUrlHandlerMappingEx_DefaultRequestContextSupportImplStub01();
        ctxSupport.setRequestName("sum");
        UTUtil.setPrivateField(handlerMapping, "ctxSupport", ctxSupport);
        
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        Object result = handlerMapping.lookupHandler(null, request);

        // 
        assertSame(null, result);
        assertTrue(LogUTUtil.checkError("Controller is not found. " + "BeanName:" 
                + "'/sumController'"));
    }

    /**
     * testLookupHandler05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() ctxSupport.getRequestName()P:"sum"<br>
     *         () prefix:"/"<br>
     *         () suffix:"Controller"<br>
     *         
     * <br>
     * ҒlF(߂l) Object:super.lookupHandlerij̖߂lƓƂmFB<br>
     *         (ԕω) super.lookupHandlerij:ĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * Rg[NameANT`̃pXwꍇ̃eXgBp^[ɈvAł̃Rg[ԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLookupHandler05() throws Exception {
        // O
        BeanNameUrlHandlerMappingEx handlerMapping = 
            new BeanNameUrlHandlerMappingEx();
        Object dummy1 = new Object();
        Object dummy2 = new Object();
        Object dummy3 = new Object();
        Map<Object, Object> handlerMap = new HashMap<Object, Object>();
        handlerMap.put("/s*", dummy1);
        handlerMap.put("/sum*", dummy2);
        handlerMap.put("/sumControll*", dummy3);
        UTUtil.setPrivateField(handlerMapping, "handlerMap", handlerMap);
        String prefix = "/";
        UTUtil.setPrivateField(handlerMapping, "prefix", prefix);
        String suffix = "Controller";
        UTUtil.setPrivateField(handlerMapping, "suffix", suffix);
        BeanNameUrlHandlerMappingEx_DefaultRequestContextSupportImplStub01 ctxSupport = 
            new BeanNameUrlHandlerMappingEx_DefaultRequestContextSupportImplStub01();
        ctxSupport.setRequestName("sum");
        UTUtil.setPrivateField(handlerMapping, "ctxSupport", ctxSupport);
        
        MockHttpServletRequest request = new MockHttpServletRequest();

        // eXg{
        Object result = handlerMapping.lookupHandler(null, request);

        // 
        assertTrue(result instanceof HandlerExecutionChain);
        assertSame(dummy3, ((HandlerExecutionChain) result).getHandler());
    }

    /**
     * testAfterPropertiesSet01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.ctxSupport:not null<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * CX^XɌĂ΂郁\bhB
     * ReLXgT|[gݒ肳Ă邩`FbNB
     * ReLXgT|[gݒ肳Ă邽߁AȂŏIp^[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet01() throws Exception {
        // O
        BeanNameUrlHandlerMappingEx handlerMapping = 
            new BeanNameUrlHandlerMappingEx();
        RequestContextSupport ctxSupport = 
            new DefaultRequestContextSupportImpl();
        UTUtil.setPrivateField(handlerMapping, "ctxSupport", ctxSupport);

        // eXg{
        handlerMapping.afterPropertiesSet();

        // ʊmFiOȂOKj
    }

    /**
     * testAfterPropertiesSet02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() this.ctxSupport:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException( "BeanNameUrlHandlerMappingEx must be set ctxSupport.")<br>
     *         (ԕω) O:BeanNameUrlHandlerMappingEx must be set ctxSupport.<br>
     *         
     * <br>
     * CX^XɌĂ΂郁\bhBReLXgT|[gݒ肳Ă邩`FbNBReLXgT|[gݒ肳ĂȂ߁AO𓊂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet02() throws Exception {
        // O
        BeanNameUrlHandlerMappingEx handlerMapping = 
            new BeanNameUrlHandlerMappingEx();
        UTUtil.setPrivateField(handlerMapping, "ctxSupport", null);

        // eXg{
        try {
            handlerMapping.afterPropertiesSet();
            fail();
        } catch (IllegalStateException e) {
            String expect = 
                "BeanNameUrlHandlerMappingEx must be set ctxSupport.";
            assertEquals(expect, e.getMessage());
            assertTrue(LogUTUtil.checkError(expect));
        }
    }
}
