/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.context.support;

import javax.servlet.http.HttpServletRequest;
import jp.terasoluna.fw.web.rich.context.RequestContext;
import jp.terasoluna.fw.web.rich.context.support.AbstractRequestContextSupport;

/**
 * AbstractRequestContextSupportTestŗpB
 * 
 */
public class AbstractRequestContextSupportImpl01 extends
        AbstractRequestContextSupport {

    // doGenerateContext()ĂяomFptO
    private boolean doGenerateContextCalled = false;

    // doGenerateContext()Ăяöێ
    private HttpServletRequest doGenerateContextArg = null;

    // getRequestContex()ŕԋpl@eXgP[XŒlݒ肷
    private RequestContext testCtx = null;

    /**
     * testCtxԋpB
     * 
     * @return testCtx
     */
    public RequestContext getTestCtx() {
        return testCtx;
    }

    /**
     * testCtxݒ肷BeXgP[XgpB
     * 
     * @param testCtx eXgpRequestContext
     */
    public void setTestCtx(RequestContext testCtx) {
        this.testCtx = testCtx;
    }

    /**
     * doGenerateContextArgԋpB
     * 
     * @return doGenerateContextArg
     */
    public HttpServletRequest getDoGenerateContextArg() {
        return doGenerateContextArg;
    }

    /**
     * doGenerateContextCalledԋpB
     * 
     * @return doGenerateContextCalled
     */
    public boolean isDoGenerateContextCalled() {
        return doGenerateContextCalled;
    }

    /**
     * getRequestContext()̌ʂԋpB
     * 
     * @return RequestContext eXgpRequestContext
     */
    @Override
    protected RequestContext doGenerateContext(HttpServletRequest request) {
        this.doGenerateContextCalled = true;
        this.doGenerateContextArg = request;
        return getRequestContext();
    }

    /**
     * testCtxԋpB
     * 
     * @return testCtx eXgpRequestContext
     */
    @Override
    protected RequestContext getRequestContext() {
        return this.testCtx;
    }
}
