/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.xsd.xerces;

import java.util.Hashtable;

import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.fw.oxm.xsd.message.ErrorMessages;
import jp.terasoluna.fw.oxm.xsd.xerces.XML11ConfigurationEx;
import jp.terasoluna.fw.oxm.xsd.xerces.XMLErrorReporterEx;
import jp.terasoluna.fw.oxm.xsd.xerces.XMLSchemaValidatorEx;
import junit.framework.TestCase;

import org.apache.xerces.impl.Constants;
import org.apache.xerces.impl.dtd.XMLDTDProcessor;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.parser.XMLDTDScanner;

/**
 * {@link jp.terasoluna.fw.oxm.xsd.xerces.XML11ConfigurationEx} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * XMLSchemaValidatorExCX^Xp[Tɐݒ肷邽߂ɁAXML11ConfigurationgNXB<br>
 * OF<br>
 * ̃NXSchemaValidatorImplŐ邱ƂOłAconfigurePipeline\bh̑Othis.fPropertiesɂ͕KXMLErrorReporterExCX^Xݒ肳ĂB
 * </p>
 * 
 * @see jp.terasoluna.fw.oxm.xsd.xerces.XML11ConfigurationEx
 */
public class XML11ConfigurationExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(XML11ConfigurationExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public XML11ConfigurationExTest(String name) {
        super(name);
    }

    /**
     * testXML11ConfigurationExXMLGrammarPool01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() grammarPool:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.fGrammarPool:null<br>
     *         
     * <br>
     * ̒lɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testXML11ConfigurationExXMLGrammarPool01() throws Exception {

        // XMLGrammarPoolݒ肳Ă邱Ƃ̊mF
        XML11ConfigurationEx config = new XML11ConfigurationEx(null);
        
        // 
        assertNull(UTUtil.getPrivateField(config, "fGrammarPool"));
        
    }

    /**
     * testXML11ConfigurationExXMLGrammarPool02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() grammarPool:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.fGrammarPool:not null<br>
     *         
     * <br>
     * ̒lɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testXML11ConfigurationExXMLGrammarPool02() throws Exception {
        // O
        XMLGrammarPoolImpl grammarPool = new XMLGrammarPoolImpl();
        
        // XMLGrammarPoolݒ肳Ă邱Ƃ̊mF
        XML11ConfigurationEx config = new XML11ConfigurationEx(grammarPool);
        
        // 
        assertEquals(grammarPool, UTUtil.getPrivateField(config, "fGrammarPool"));
    }
    
    /**
     * testConfigurePipeline01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.fFeatures:HashMap{<br>
     *                 Constants.SAX_FEATURE_PREFIX<br>
     *                                    + Constants.VALIDATION_FEATURE<br>
     *                  = false<br>
     *                }<br>
     *         () this.fProperties:HashMap{<br>
     *                  Constants.XERCES_PROPERTY_PREFIX<br>
     *                                + Constants.ERROR_REPORTER_PROPERTY<br>
     *                  = XMLErrorReporterExCX^X<br>
     *                }<br>
     *         () setProperty():[<br>
     *         () addCommonComponent():ĂяoȂƂmFB<br>
     *         () fSchemaValidator.reset():[<br>
     *         () super.configurePipeline():ĂяoꂽƂ̂݊mFB<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * this.fFeaturesXMLSCEHMA_VALIDATIONL[falsȅꍇAsuper.configurePipeline()\bhĂяoꂽƁAnꂽƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConfigurePipeline01() throws Exception {
        XML11ConfigurationEx_XML11ConfigurationExStub01 xmlConfiguration = new XML11ConfigurationEx_XML11ConfigurationExStub01();
        xmlConfiguration.setFeature(Constants.SAX_FEATURE_PREFIX
                + Constants.VALIDATION_FEATURE, false);

        XMLDTDProcessor dtdProcessor = new XMLDTDProcessor();

        UTUtil.setPrivateField(xmlConfiguration, "fDTDProcessor", dtdProcessor);
        xmlConfiguration.configurePipeline();

        // ifsĂȂƂ̊mF
        assertFalse(xmlConfiguration.isAddCommonComponent);
        
        // super.configurePipeline()̌ĂяomF
        XMLDTDScanner fDTDScanner = (XMLDTDScanner) UTUtil.getPrivateField(
                xmlConfiguration, "fDTDScanner");
        assertSame(dtdProcessor, fDTDScanner.getDTDHandler());
    }

    /**
     * testConfigurePipeline02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.fFeatures:HashMap{<br>
     *                  Constants.SAX_FEATURE_PREFIX<br>
     *                                    + Constants.VALIDATION_FEATURE<br>
     *                  = true<br>
     *                }<br>
     *         () this.fProperties:HashMap{<br>
     *                  Constants.XERCES_PROPERTY_PREFIX<br>
     *                                + Constants.ERROR_REPORTER_PROPERTY<br>
     *                  = XMLErrorReporterExCX^X<br>
     *                }<br>
     *         () fErrorReporter.fMessageFormatters:HashMap̃L[wXSMessageFormatter.SCHEMA_DOMAINx݂<br>
     *         () setProperty():ĂяoꂽƂmFB<br>
     *                ݒ肳ꂽƂmFB<br>
     *         () addCommonComponent():ĂяoꂽƂmFB<br>
     *                ݒ肳ꂽƂmFB<br>
     *         () fSchemaValidator.reset():ĂяoꂽƂmFB<br>
     *                ݒ肳ꂽƂmFB<br>
     *         () fErrorReporter.putMessageFormatter():ĂяoȂƂmFB<br>
     *         () super.configurePipeline():ĂяoꂽƂ̂݊mFB<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * this.fFeaturesXMLSCEHMA_VALIDATIONL[trueA<br>
     * fErrorReporter.fMessageFormatters̃L[wXSMessageFormatter.SCHEMA_DOMAINx݂ꍇAe\bhĂяoꂽƁAnꂽƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testConfigurePipeline02() throws Exception {
        XML11ConfigurationEx_XML11ConfigurationExStub01 xmlConfiguration = new XML11ConfigurationEx_XML11ConfigurationExStub01();
        xmlConfiguration.setFeature(Constants.XERCES_FEATURE_PREFIX
                + Constants.SCHEMA_VALIDATION_FEATURE, true);

        // ErrorReporterExZbg
        XMLErrorReporterEx errorReporterEx = new XMLErrorReporterEx(new ErrorMessages());
        xmlConfiguration.setProperty(Constants.XERCES_PROPERTY_PREFIX
                + Constants.ERROR_REPORTER_PROPERTY, errorReporterEx);

        // fErrorReporterMessageFormatterZbg
        XML11ConfigurationEx_XMLErrorReporterStub01 errorReporter = new XML11ConfigurationEx_XMLErrorReporterStub01();
        UTUtil.setPrivateField(xmlConfiguration, "fErrorReporter", errorReporter);
        Hashtable fMessageFormatters = (Hashtable) UTUtil.getPrivateField(
                errorReporter, "fMessageFormatters");
        XSMessageFormatter xsMessageFormatter = new XSMessageFormatter();
        fMessageFormatters.put(XSMessageFormatter.SCHEMA_DOMAIN,
                xsMessageFormatter);

        XMLDTDProcessor dtdProcessor = new XMLDTDProcessor();
        UTUtil.setPrivateField(xmlConfiguration, "fDTDProcessor", dtdProcessor);

        // eXg{
        xmlConfiguration.configurePipeline();

        // 
        // setProperty\bȟĂяomF
        XMLSchemaValidator xmlSchemaValidator = (XMLSchemaValidator) xmlConfiguration
        .getProperty((String) UTUtil.getPrivateField(xmlConfiguration,
                "SCHEMA_VALIDATOR"));
        assertSame(XMLSchemaValidatorEx.class, xmlSchemaValidator.getClass());
        assertSame(errorReporterEx, UTUtil.getPrivateField(xmlSchemaValidator,
                "reporter"));

        // addCommonComponent\bȟĂяomF
        assertTrue(xmlConfiguration.isAddCommonComponent);

        // fSchemaValidator.reset\bȟĂяomF
        CMNodeFactory cmNodeFactory = (CMNodeFactory) UTUtil.getPrivateField(
                xmlSchemaValidator, "nodeFactory");
        assertSame(errorReporterEx, UTUtil.getPrivateField(cmNodeFactory,
                "fErrorReporter"));
        
        // ifsĂȂƂ̊mF
        assertFalse(errorReporter.isPutMessageFormatter);

        // super.configurePipeline\bȟĂяomF
        XMLDTDScanner fDTDScanner = (XMLDTDScanner) UTUtil.getPrivateField(
                xmlConfiguration, "fDTDScanner");
        assertSame(dtdProcessor, fDTDScanner.getDTDHandler());
    }

    /**
     * testConfigurePipeline03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.fFeatures:HashMap{<br>
     *                  Constants.SAX_FEATURE_PREFIX<br>
     *                                    + Constants.VALIDATION_FEATURE<br>
     *                  = true<br>
     *                }<br>
     *         () this.fProperties:HashMap{<br>
     *                  Constants.XERCES_PROPERTY_PREFIX<br>
     *                                + Constants.ERROR_REPORTER_PROPERTY<br>
     *                  = XMLErrorReporterExCX^X<br>
     *                }<br>
     *         () fErrorReporter.fMessageFormatters:HashMap̃L[wXSMessageFormatter.SCHEMA_DOMAINx݂Ȃ<br>
     *         () setProperty():ĂяoꂽƂmFB<br>
     *                ݒ肳ꂽƂmFB<br>
     *         () addCommonComponent():ĂяoꂽƂmFB<br>
     *                ݒ肳ꂽƂmFB<br>
     *         () fSchemaValidator.reset():ĂяoꂽƂmFB<br>
     *                ݒ肳ꂽƂmFB<br>
     *         () fErrorReporter.putMessageFormatter():ĂяoꂽƂmFB<br>
     *                ݒ肳ꂽƂmFB<br>
     *         () super.configurePipeline():ĂяoꂽƂ̂݊mFB<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * this.fFeaturesXMLSCEHMA_VALIDATIONL[trueA<br>
     * fErrorReporter.fMessageFormatters̃L[wXSMessageFormatter.SCHEMA_DOMAINx݂ȂꍇAe\bhĂяoꂽƁAnꂽƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testConfigurePipeline03() throws Exception {
        XML11ConfigurationEx_XML11ConfigurationExStub01 xmlConfiguration = new XML11ConfigurationEx_XML11ConfigurationExStub01();
        xmlConfiguration.setFeature(Constants.XERCES_FEATURE_PREFIX
                + Constants.SCHEMA_VALIDATION_FEATURE, true);

        // ErrorReporterExZbg
        XMLErrorReporterEx errorReporterEx = new XMLErrorReporterEx(
                new ErrorMessages());
        xmlConfiguration.setProperty(Constants.XERCES_PROPERTY_PREFIX
                + Constants.ERROR_REPORTER_PROPERTY, errorReporterEx);

        // fErrorReporter.fMessageFormattersHashtableXSMessageFormatter.SCHEMA_DOMAIN̒l폜
        XML11ConfigurationEx_XMLErrorReporterStub01 errorReporter = new XML11ConfigurationEx_XMLErrorReporterStub01();
        UTUtil.setPrivateField(xmlConfiguration, "fErrorReporter", errorReporter);
        Hashtable fMessageFormatters = (Hashtable) UTUtil.getPrivateField(
                errorReporter, "fMessageFormatters");

        fMessageFormatters.remove(XSMessageFormatter.SCHEMA_DOMAIN);

        // super.configurePipeline\bȟĂяomFŎgp
        XMLDTDProcessor dtdProcessor = new XMLDTDProcessor();
        UTUtil.setPrivateField(xmlConfiguration, "fDTDProcessor", dtdProcessor);

        // eXg{
        xmlConfiguration.configurePipeline();

        // 
        XMLSchemaValidator xmlSchemaValidator = (XMLSchemaValidator) xmlConfiguration
                .getProperty((String) UTUtil.getPrivateField(xmlConfiguration,
                        "SCHEMA_VALIDATOR"));

        // setProperty\bȟĂяomF
        assertSame(XMLSchemaValidatorEx.class, xmlSchemaValidator.getClass());

        // getProperty\bȟĂяomF
        assertSame(errorReporterEx, UTUtil.getPrivateField(xmlSchemaValidator,
                "reporter"));

        // addCommonComponent\bȟĂяomF
        assertTrue(xmlConfiguration.isAddCommonComponent);

        // fSchemaValidator.reset\bȟĂяomF
        CMNodeFactory cmNodeFactory = (CMNodeFactory) UTUtil.getPrivateField(
                xmlSchemaValidator, "nodeFactory");
        assertSame(errorReporterEx, UTUtil.getPrivateField(cmNodeFactory,
                "fErrorReporter"));

        // fErrorReporter.putMessageFormatter\bȟĂяomF
        assertTrue(errorReporter.isPutMessageFormatter);

        // super.configurePipeline\bȟĂяomF
        XMLDTDScanner fDTDScanner = (XMLDTDScanner) UTUtil.getPrivateField(
                xmlConfiguration, "fDTDScanner");
        assertSame(dtdProcessor, fDTDScanner.getDTDHandler());

    }

}
