/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.controllerex.controller;

import jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController;
import jp.terasoluna.rich.functionsample.controllerex.bean.ControllerExFileData;
import jp.terasoluna.rich.functionsample.controllerex.service.FileDownloadService;

/**
 * Rg[g̃t@C_E[hRg[
 *
 */
public class ControllerExFileController extends
        TerasolunaController<ControllerExFileData, ControllerExFileData> {
    
    /**
     * Rg[g̃t@C_E[hT[rXNX
     */
    protected FileDownloadService fileDownloadService = null;

    /**
     * Rg[g̃t@C_E[hT[rXNX̎s\bhsB
     *
     * @param command ̓NX
     * @return ̓NX
     * @throws Exception O
     */
    @Override
    protected ControllerExFileData executeService(ControllerExFileData command)
                    throws Exception {
        return fileDownloadService.executeFiledownload(command);
    }

    /**
     * Rg[g̃t@C_E[hT[rXNXݒ肷B
     * @param fileDownloadService Rg[g̃t@C_E[hT[rXNX
     */
    public void setFileDownloadService(FileDownloadService
            fileDownloadService) {
        this.fileDownloadService = fileDownloadService;
    }
    

}
