/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.net.URLEncoder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.mock.web.MockHttpServletRequest;

import jp.terasoluna.utlib.MockHttpServletResponse;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.DownloadFileNameEncoderImpl} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * _E[h̎wt@CGR[hNXB<br>
 * ̃NXłInternet Explorer݂̂ɑΉĂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.DownloadFileNameEncoderImpl
 */
public class DownloadFileNameEncoderImplTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DownloadFileNameEncoderImplTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DownloadFileNameEncoderImplTest(String name) {
        super(name);
    }

    /**
     * testEncode01()
     * <br><br>
     * 
     *  (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() original:null<br>
     *         () request:MockHttpServletRequest<br>
     *         () response:MockHttpServletResponse<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         
     * <br>
     * ϐnull̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testEncode01() throws Exception {
        // O
        DownloadFileNameEncoderImpl encoderImpl = new DownloadFileNameEncoderImpl();
        HttpServletRequest request = new MockHttpServletRequest();
        HttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        String str = encoderImpl.encode(null, request, response);

        // 
        assertNull(str);
    }

    /**
     * testEncode02()
     * <br><br>
     * 
     *  (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() original:"  "i󔒁j<br>
     *         () request:MockHttpServletRequest<br>
     *         () response:MockHttpServletResponse<br>
     *         
     * <br>
     * ҒlF(߂l) String:"  "i󔒁j<br>
     *         
     * <br>
     * ϐ󔒂̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testEncode02() throws Exception {
        // O
        DownloadFileNameEncoderImpl encoderImpl = new DownloadFileNameEncoderImpl();
        HttpServletRequest request = new MockHttpServletRequest();
        HttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        String str = encoderImpl.encode("  ", request, response);

        // 
        assertEquals(URLEncoder.encode("  ",
                AbstractDownloadObject.DEFAULT_CHARSET), str);
    }

    /**
     * testEncode03()
     * <br><br>
     * 
     *  (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() original:""i󕶎j<br>
     *         () request:MockHttpServletRequest<br>
     *         () response:MockHttpServletResponse<br>
     *         
     * <br>
     * ҒlF(߂l) String:""i󕶎j<br>
     *         
     * <br>
     * ϐ󕶎̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testEncode03() throws Exception {
        // O
        DownloadFileNameEncoderImpl encoderImpl = new DownloadFileNameEncoderImpl();
        HttpServletRequest request = new MockHttpServletRequest();
        HttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        String str = encoderImpl.encode("", request, response);

        // 
        assertEquals(URLEncoder.encode("",
                AbstractDownloadObject.DEFAULT_CHARSET), str);
    }

    /**
     * testEncode04()
     * <br><br>
     * 
     *  (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() original:"abc"<br>
     *         () request:MockHttpServletRequest<br>
     *         () response:MockHttpServletResponse<br>
     *         
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     *         
     * <br>
     * ϐp̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testEncode04() throws Exception {
        // O
        DownloadFileNameEncoderImpl encoderImpl = new DownloadFileNameEncoderImpl();
        HttpServletRequest request = new MockHttpServletRequest();
        HttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        String str = encoderImpl.encode("abc", request, response);

        // 
        assertEquals(URLEncoder.encode("abc",
                AbstractDownloadObject.DEFAULT_CHARSET), str);
    }

    /**
     * testEncode05()
     * <br><br>
     * 
     *  (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() original:""(UTF-8)<br>
     *         () request:MockHttpServletRequest<br>
     *         () response:MockHttpServletResponse<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * ϐ{ꕶ̏ꍇAGR[hĕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testEncode05() throws Exception {
        // O
        DownloadFileNameEncoderImpl encoderImpl = new DownloadFileNameEncoderImpl();
        HttpServletRequest request = new MockHttpServletRequest();
        HttpServletResponse response = new MockHttpServletResponse();

        // eXg{
        String str = encoderImpl.encode("", request, response);

        // 
        assertEquals(URLEncoder.encode("",
                AbstractDownloadObject.DEFAULT_CHARSET), str);
    }

}
