/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.messageex.service;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.thin.functionsample.messageex.bean.MessageExScopeParam;


/**
 * XR[vbZ[Wi[NX
 *
 */
public class MessageExScopeServiceImpl 
                                    implements MessageExScopeService {

    /**
     * bZ[WL[̋ʕ
     */
    private static final String COMMON_MSG = "message.UC21.0000";
    /**
     * G[bZ[WL[̋ʕ
     */
    private static final String COMMON_ERR = "errors.UC21.0000";
    
    /**
     * PDi[ɂăbZ[WL[ݒ肷B<br>
     * QDi[ɂăG[L[ݒ肷B
     *
     * @param param i[p[^[NX
     * @return bZ[WL[ƃG[L[
     */
    public Map<Integer, String> execute(MessageExScopeParam param) {
        
        Map<Integer, String> messKey = new HashMap<Integer, String>();
        
        /*
         * i[ɃbZ[WL[ݒ肷B
         */
        
        for (int i=0; i<4; i++) {
            String msgKey = null;
            String errKey = null;
            if (param.getCode1() == i+1) {
                msgKey = COMMON_MSG + 1;
                errKey = COMMON_ERR + 1;
            }
            else if (param.getCode2() == i+1) {
                msgKey = COMMON_MSG + 2;
                errKey = COMMON_ERR + 2;
            } 
            else if (param.getCode3() == i+1) {
                msgKey = COMMON_MSG + 3;
                errKey = COMMON_ERR + 3;
            } 
            else if (param.getCode4() == i+1) {
                msgKey = COMMON_MSG + 4;
                errKey = COMMON_ERR + 4;
            }
            else {
                errKey = COMMON_ERR + 5;
                messKey.clear();
                messKey.put(4, errKey);
                break;
            }
            messKey.put(i, msgKey);
            messKey.put(i+4, errKey);
        }
        return messKey;
    }
}