<?php
/*
  $Id: jppercelsal.php,v 1.0 2004/06/17 13:14:08 ptosh Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/
//
// ⥸塼 ͹ʪ:ΥߡҶ(SAL)
// TAMURA Toshihiko (tamura@bitscope.co.jp)
//
// [Ϣե]
// catalog/includes/modules/shipping/jppercelsal.php
// catalog/includes/classes/_jppercel.php
// catalog/includes/languages/japanese/modules/shipping/jppercelsal.php
// catalog/images/icons/shipping_jppercelsal.gif
//
  class jppercelsal {
    var $code, $title, $description, $sort_order, $icon, $tax_class, $enabled;
    var $country_code;
    var $quote;

// class constructor
    function jppercelsal() {
      global $order;

      $this->code        = 'jppercelsal';
      $this->title       = MODULE_SHIPPING_JPPERCELSAL_TEXT_TITLE;
      $this->description = MODULE_SHIPPING_JPPERCELSAL_TEXT_DESCRIPTION;
      $this->sort_order  = MODULE_SHIPPING_JPPERCELSAL_SORT_ORDER;
      $this->icon        = NULL; //DIR_WS_ICONS . 'shipping_jppercelsal.gif';
      $this->tax_class   = in_array('MODULE_SHIPPING_JPPERCELSAL_TAX_CLASS',$this->keys()) ? MODULE_SHIPPING_JPPERCELSAL_TAX_CLASS : 0;
      $this->enabled = (((MODULE_SHIPPING_JPPERCELSAL_STATUS == 'True')
                        && (STORE_ORIGIN_COUNTRY == 'JP')
                        && $order->delivery['country']['id']) ? true : false);

      if ( $this->enabled == true ) {
        $countries = tep_db_query("SELECT countries_iso_code_2 FROM " . TABLE_COUNTRIES
                     . " WHERE countries_id = '" . (int)$order->delivery['country']['id'] . "' ORDER BY countries_name");
        $countries_values = tep_db_fetch_array($countries);
        $this->country_code = $countries_values['countries_iso_code_2'];
        if ($this->country_code == STORE_ORIGIN_COUNTRY) {
          $this->enabled = false;
        }
      }
    }

// class methods
    function quote() {
      global $shipping_weight, $shipping_num_boxes;
      global $order;
      global $cart;

      $this->quotes = array('id' => $this->code, 'module' => $this->title);
      if (tep_not_null($this->icon)) $this->quotes['icon'] = tep_image($this->icon, $this->title);

      if ($this->country_code != 'JP') {
          if ( (MODULE_SHIPPING_JPPERCELSAL_FREE_SHIPPING != 'True') || ((int)$cart->show_total() < (int)MODULE_SHIPPING_JPPERCELSAL_OVER) ) {
              include(DIR_WS_CLASSES . '_jppercel.php');
              $rate = new _JpPercel($this->code, MODULE_SHIPPING_JPPERCELSAL_TEXT_WAY_NORMAL, $this->country_code);
              $rate->SetWeight($shipping_weight);
              $tmpQuote = $rate->GetQuote(); // id, title, cost | error

              if (isset($tmpQuote['error'])) {
                  $this->quotes['error'] = $tmpQuote['error'];
              } else {
                  $this->quotes['module'] = $this->title
                      . ' (' . $shipping_num_boxes . ' x ' . $shipping_weight . 'kg)';

                  $tmpQuote['cost'] *= $shipping_num_boxes;
                  // ǥ
                  if (defined('MODULE_SHIPPING_JPPERCELSAL_DISCOUNT') && 0 < (int)MODULE_SHIPPING_JPPERCELSAL_DISCOUNT) {
                      $tmpQuote['cost'] -= (int)($tmpQuote['cost'] * MODULE_SHIPPING_JPPERCELSAL_DISCOUNT / 100);
                  }
                  // 
                  $tmpQuote['cost'] += MODULE_SHIPPING_JPPERCELSAL_HANDLING;
              }
          } else {
              $tmpQuote = array('id' => $this->code, 'title' => MODULE_SHIPPING_JPPERCELSAL_TEXT_WAY_NORMAL, 'cost' => 0);
          }

          $this->quotes['methods'][] = $tmpQuote;

          //if ($this->tax_class > 0) {
          //    $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $country_id, $zone_id);
          //}
        } else {
            $this->quotes['error'] = MODULE_SHIPPING_JPPERCEL_TEXT_NOTAVAILABLE;
        }

        return $this->quotes;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from "
          . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_JPPERCELSAL_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('ݾ͹ʪ(ΥߡҶ[SAL])ͭˤ', 'MODULE_SHIPPING_JPPERCELSAL_STATUS', 'True', 'ݾ͹ʪ(ΥߡҶ[SAL])󶡤ޤ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('谷', 'MODULE_SHIPPING_JPPERCELSAL_HANDLING', '0', 'ŬѤ谷Ǥޤ.', '6', '1', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('̵', 'MODULE_SHIPPING_JPPERCELSAL_FREE_SHIPPING', 'False', '̵ͭˤޤ? [ץ⥸塼]-[]-[̵]ͥ褹 False Ǥ.', '6', '2', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

      tep_db_query("INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('̵ˤ', 'MODULE_SHIPPING_JPPERCELSAL_OVER', '5000', '۰ʾ򤴹ξ̵ˤޤ.', '6', '3', now())");

      tep_db_query("INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('ͰΨ', 'MODULE_SHIPPING_JPPERCELSAL_DISCOUNT', '0', 'ͰΨꤷޤ.()', '6', '4', now())");

//    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Ǽ', 'MODULE_SHIPPING_JPPERCELSAL_TAX_CLASS', '0', 'ŬѤǼ̤Ǥ.', '6', '3', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('ɽ', 'MODULE_SHIPPING_JPPERCELSAL_SORT_ORDER', '0', 'ɽǤޤ. ۤɾ̤ɽޤ.', '6', '6', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array(
        'MODULE_SHIPPING_JPPERCELSAL_STATUS',
        'MODULE_SHIPPING_JPPERCELSAL_HANDLING',
        'MODULE_SHIPPING_JPPERCELSAL_FREE_SHIPPING',
        'MODULE_SHIPPING_JPPERCELSAL_OVER',
        'MODULE_SHIPPING_JPPERCELSAL_DISCOUNT',
//      'MODULE_SHIPPING_JPPERCELSAL_TAX_CLASS',
        'MODULE_SHIPPING_JPPERCELSAL_SORT_ORDER',
      );
    }
  }
?>