<?php
/*
  $Id: _jppercel.php,v 1.0 2004/06/17 11:28:46 ptosh Exp $

  Japanese Postal Service Shipping Calculator.
  Calculate shipping costs.

  2004/06/17 written by TAMURA Toshihiko (tamura@bitscope.co.jp)
 */
/*
(Ŭ륵ӥ)
ʲμ̤б׻롣
-----------------------------------------------
                               id
-----------------------------------------------
͹ʪ:Ҷ                jppercelair
͹ʪ:ΥߡҶ(SAL) jppercelsal
͹ʪ:ؾ                jppercelsea
ݥԡ͹(EMS)              jppercelems
-----------------------------------------------

()
͹ɽ:
 http://www.post.japanpost.jp/fee/simulator/kokusai/
͹ؾɽ:
 http://www.post.japanpost.jp/service/intel_service/ko_johken/html/naate.htm
ISO񥳡:
 http://www.iso.org/iso/en/prods-services/iso3166ma/02iso-3166-code-lists/list-en1.html

(ˡ)
    $percel = new _JpPercel('jppercelair','Ҷ');
    $percel->SetDest('US');     // ꥫ罰ޤ
    $percel->SetWeight(10);     // kg
    $quote = $percel->GetQuote();
    print $quote['title']."(". $quote['id'] . "): cost=" . $quote['cost'] . "<br>\n";
*/
if ( !defined('JPPERCEL') ) {
  define('JPPERCEL', 1);

class _JpPercel {
    var $quote;
    var $DestCountryCode = NULL;
    var $Weight = 0;
    var $Areas = array(
/* 쥢   */ 'easia'   =>array('CN','HK','TW','KR','PH','MO','MN'),
/* ʿ   */ 'wpacific'=>array('GU','MP'),
/*  */ 'seasia'  =>array('SG','TH','MY','VN','ID','KH','BN','MM','LA'),
/*  */ 'swasia'  =>array('IN','LK','NP','PK','BD','BT','MV'),
/* ˥ */ 'oceania' =>array('AU','SB','NZ','NC','PG','FJ'),
/*      */ 'mneast'  =>array('AE','IL','IQ','IR','OM','QA','KW','CY','SY','SA','JO','TR','BH'),
/* 衼å */ 'europe'  =>array('IS','IE','AZ','IT','UA','GB','EE','AT','NL','GR','HR','CH',
                                   'SE','ES','SK','SI','CZ','DK','DE','NO','HU','FR','FI','BY',
                                   'BE','BG','PL','PT','MK','MT','LV','LT','LI','LU','RO','RU'),
/*        */ 'namerica'=>array('US','CA'),
/*        */ 'camerica'=>array('SV','CU','CR','TT','JM','PA','BB','HN','MX'),
/*        */ 'samerica'=>array('AR','UY','VE','EC','CO','CL','PY','BR','PE'),
/* եꥫ   */ 'africa'  =>array('DZ','UG','EG','ET','GH','GA','KE','SL','SD','DJ','ZW','SN',
                                   'CI','TZ','TN','TG','NG','BW','MG','ZA','MU','MA','RW'),
    );
    // ͹ʪβʥ: ((kg),1,2,3,4)
    var $a_price_percel = array(
    // ͹ʪ:Ҷ
    'jppercelair'=>array(
      array( 0.5, 1700, 2100, 2500, 3200),// 0.5kgʲ,1,2,3,4
      array( 1.0, 2050, 2700, 3350, 4600),
      array( 1.5, 2400, 3300, 4200, 6000),
      array( 2.0, 2750, 3900, 5050, 7400),
      array( 2.5, 3100, 4500, 5900, 8800),
      array( 3.0, 3450, 5100, 6750,10200),
      array( 3.5, 3800, 5700, 7600,11600),
      array( 4.0, 4150, 6300, 8450,13000),
      array( 4.5, 4500, 6900, 9300,14400),
      array( 5.0, 4850, 7500,10150,15800),
      array( 5.5, 5150, 8000,10900,17000),
      array( 6.0, 5450, 8500,11650,18200),
      array( 6.5, 5750, 9000,12400,19400),
      array( 7.0, 6050, 9500,13150,20600),
      array( 7.5, 6350,10000,13900,21800),
      array( 8.0, 6650,10500,14650,23000),
      array( 8.5, 6950,11000,15400,24200),
      array( 9.0, 7250,11500,16150,25400),
      array( 9.5, 7550,12000,16900,26600),
      array(10.0, 7850,12500,17650,27800),
      array(11.0, 8250,13200,18600,29400),
      array(12.0, 8650,13900,19550,31000),
      array(13.0, 9050,14600,20500,32600),
      array(14.0, 9450,15300,21450,34200),
      array(15.0, 9850,16000,22400,35800),
      array(16.0,10250,16700,23350,37400),
      array(17.0,10650,17400,24300,39000),
      array(18.0,11050,18100,25250,40600),
      array(19.0,11450,18800,26200,42200),
      array(20.0,11850,19500,27150,43800),
      array(21.0,12250,20200,28100,45400),
      array(22.0,12650,20900,29050,47000),
      array(23.0,13050,21600,30000,48600),
      array(24.0,13450,22300,30950,50200),
      array(25.0,13850,23000,31900,51800),
      array(26.0,14250,23700,32850,53400),
      array(27.0,14650,24400,33800,55000),
      array(28.0,15050,25100,34750,56500),
      array(29.0,15450,25800,35700,58200),
      array(30.0,15850,26500,36650,59800),
      ),
    // ͹ʪ:ΥߡҶ(SAL)
    'jppercelsal'=>array(
      array( 0.5, 1800, 2200, 2700, 3400),// 0.5kgʲ,1,2,3,4
      array( 1.0, 1800, 2200, 2700, 3400),
      array( 1.5, 2400, 2900, 3850, 5000),
      array( 2.0, 2400, 2900, 3850, 5000),
      array( 2.5, 3000, 3600, 5000, 6600),
      array( 3.0, 3000, 3600, 5000, 6600),
      array( 3.5, 3600, 4300, 6150, 8200),
      array( 4.0, 3600, 4300, 6150, 8200),
      array( 4.5, 4200, 5000, 7300, 9800),
      array( 5.0, 4200, 5000, 7300, 9800),
      array( 5.5, 4700, 5600, 8350,11250),
      array( 6.0, 4700, 5600, 8350,11250),
      array( 6.5, 5200, 6200, 9400,12700),
      array( 7.0, 5200, 6200, 9400,12700),
      array( 7.5, 5700, 6800,10450,14150),
      array( 8.0, 5700, 6800,10450,14150),
      array( 8.5, 6200, 7400,11500,15600),
      array( 9.0, 6200, 7400,11550,15600),
      array( 9.5, 6700, 8000,12550,17050),
      array(10.0, 6700, 8000,12550,17050),
      array(11.0, 7000, 8400,13250,18050),
      array(12.0, 7300, 8800,13950,19050),
      array(13.0, 7600, 9200,14650,20050),
      array(14.0, 7900, 9600,15350,21050),
      array(15.0, 8200,10000,16050,22050),
      array(16.0, 8500,10400,16750,23050),
      array(17.0, 8800,10800,17450,24050),
      array(18.0, 9100,11200,18150,25050),
      array(19.0, 9400,11600,18850,26050),
      array(20.0, 9700,12000,19550,27050),
      array(21.0,10000,12400,20250,28050),
      array(22.0,10300,12800,20950,29050),
      array(23.0,10600,13200,21650,30050),
      array(24.0,10900,13600,22350,31050),
      array(25.0,11200,14000,23050,32050),
      array(26.0,11500,14400,23750,33050),
      array(27.0,11800,14800,24450,34050),
      array(28.0,12100,15200,25150,35050),
      array(29.0,12400,15600,25850,36050),
      array(30.0,12700,16000,26550,37050),
      ),
    // ͹ʪ:ؾ
    'jppercelsea'=>array(
      array( 0.5, 1500, 1700, 1800, 2200),// 0.5kgʲ,1,2,3,4
      array( 1.0, 1500, 1700, 1800, 2200),
      array( 1.5, 1750, 2100, 2350, 2650),
      array( 2.0, 1750, 2100, 2350, 2650),
      array( 2.5, 2000, 2500, 2900, 3100),
      array( 3.0, 2000, 2500, 2900, 3100),
      array( 3.5, 2250, 2900, 3450, 3550),
      array( 4.0, 2250, 2900, 3450, 3550),
      array( 4.5, 2500, 3300, 4000, 4000),
      array( 5.0, 2500, 3300, 4000, 4000),
      array( 5.5, 2750, 3700, 4550, 4450),
      array( 6.0, 2750, 3700, 4550, 4450),
      array( 6.5, 3000, 4100, 5100, 4900),
      array( 7.0, 3000, 4100, 5100, 4900),
      array( 7.5, 3250, 4500, 5650, 5350),
      array( 8.0, 3250, 4500, 5650, 5350),
      array( 8.5, 3500, 4900, 6200, 5800),
      array( 9.0, 3500, 4900, 6200, 5800),
      array( 9.5, 3750, 5300, 6750, 6250),
      array(10.0, 3750, 5300, 6750, 6250),
      array(11.0, 3950, 5600, 7100, 6600),
      array(12.0, 4150, 5900, 7450, 6950),
      array(13.0, 4350, 6200, 7800, 7300),
      array(14.0, 4550, 6500, 8150, 7650),
      array(15.0, 4750, 6800, 8500, 8000),
      array(16.0, 4950, 7100, 8850, 8350),
      array(17.0, 5150, 7400, 9200, 8700),
      array(18.0, 5350, 7700, 9550, 9050),
      array(19.0, 5550, 8000, 9900, 9400),
      array(20.0, 5750, 8300,10250, 9750),
      array(21.0, 5950, 8600,10600,10100),
      array(22.0, 6150, 8900,10950,10450),
      array(23.0, 6350, 9200,11300,10800),
      array(24.0, 6550, 9500,11650,11150),
      array(25.0, 6750, 9800,12000,11500),
      array(26.0, 6950,10100,12350,11850),
      array(27.0, 7150,10400,12700,12200),
      array(28.0, 7350,10700,13050,12550),
      array(29.0, 7550,11000,13400,12900),
      array(30.0, 7750,11300,13750,13250),
      ),
    // ݥԡ͹(EMS)
    'jppercelems'=>array(
      array( 0.3,  900, 1200, 1500, 1700),// 0.3kgʲ,1,2-1,2-2,3
      array( 0.5, 1100, 1500, 1800, 2100),
      array( 0.6, 1240, 1680, 2000, 2440),
      array( 0.7, 1380, 1860, 2200, 2780),
      array( 0.8, 1520, 2040, 2400, 3120),
      array( 0.9, 1660, 2220, 2600, 3460),
      array( 1.0, 1800, 2400, 2800, 3800),
      array( 1.25,2100, 2800, 3250, 4600),
      array( 1.5, 2400, 3200, 3700, 5400),
      array( 1.75,2700, 3600, 4150, 6200),
      array( 2.0, 3000, 4000, 4600, 7000),
      array( 2.5, 3500, 4700, 5400, 8500),
      array( 3.0, 4000, 5400, 6200,10000),
      array( 3.5, 4500, 6100, 7000,11500),
      array( 4.0, 5000, 6800, 7800,13000),
      array( 4.5, 5500, 7500, 8600,14500),
      array( 5.0, 6000, 8200, 9400,16000),
      array( 5.5, 6500, 8900,10200,17500),
      array( 6.0, 7000, 9600,11000,19000),
      array( 7.0, 7800,10700,12300,21100),
      array( 8.0, 8600,11800,13600,23200),
      array( 9.0, 9400,12900,14900,25300),
      array(10.0,10200,14000,16200,27400),
      array(11.0,11000,15100,17500,29500),
      array(12.0,11800,16200,18800,31600),
      array(13.0,12600,17300,20100,33700),
      array(14.0,13400,18400,21400,35800),
      array(15.0,14200,19500,22700,37900),
      array(16.0,15000,20600,24000,40000),
      array(17.0,15800,21700,25300,42100),
      array(18.0,16600,22800,26600,44200),
      array(19.0,17400,23900,27900,43600),
      array(20.0,18200,25000,29200,48400),
      array(21.0,19000,26100,30500,50500),
      array(22.0,19800,27200,31800,52600),
      array(23.0,20600,28300,33100,54700),
      array(24.0,21400,29400,34400,56800),
      array(25.0,22200,30500,35700,59800),
      array(26.0,23000,31600,37000,61000),
      array(27.0,23800,32700,38300,63100),
      array(28.0,24600,33800,39600,65200),
      array(29.0,25400,34900,40900,67300),
      array(30.0,26200,36000,42200,69400),
      ),
    );

    // 󥹥ȥ饯
    // $id:   module id
    // $titl: module name
    // $country: country code
    function _JpPercel($id, $title, $country = NULL) {
        $this->quote = array('id' => $id, 'title' => $title);
        $this->SetDest($country);
    }
    function SetDest($country) {
        if($country) {
            $this->DestCountryCode = $country;
        }
    }
    function SetWeight($weight) {
        $this->Weight = $weight;
    }
    // 񥳡ɤ򥨥ꥢ̾Ѵ
    // 񥳡ɤĤʤжʸ֤
    function GetAreaName($contry_code) {
        foreach ($this->Areas as $areaname => $a_country) {
            if ( in_array($contry_code, $a_country) ) {
                return $areaname;
            }
        }
        return '';
    }
    // ꥢֹ̾(14)Ѵ
    // $areaname: ꥢ̾
    function GetZoneNo($areaname) {
        $area_to_no = array();

        switch ($this->quote['id']) {
        case 'jppercelair':
        case 'jppercelsal':
        case 'jppercelsea':
          $area_to_no = array(
            'easia'   =>1, //쥢
            'wpacific'=>1, //ʿ
            'seasia'  =>2, //
            'swasia'  =>2, //
            'oceania' =>3, //˥
            'mneast'  =>3, //
            'europe'  =>3, //衼å
            'namerica'=>3, //
            'camerica'=>3, //
            'samerica'=>4, //
            'africa'  =>4, //եꥫ
          );
          break;
        case 'jppercelems':
          $area_to_no = array(
            'easia'   =>1, //쥢
            'wpacific'=>1, //ʿ
            'seasia'  =>1, //
            'swasia'  =>1, //
            'oceania' =>2, //˥
            'mneast'  =>2, //
            'europe'  =>3, //衼å
            'namerica'=>2, //
            'camerica'=>2, //
            'samerica'=>4, //
            'africa'  =>4, //եꥫ
          );
          break;
        }
        return $area_to_no[$areaname];
    }

    function GetQuote() {
        $this->quote['cost'] = 0;
        $areaname = $this->GetAreaName($this->DestCountryCode);
        if ( $areaname ) {
            $no = $this->GetZoneNo($areaname);
            if ( $no ) {
                // ʥ: ((kg),1,2,3,4)
                foreach($this->a_price_percel[$this->quote['id']] as $a_set) {
                    if ($this->Weight <= $a_set[0]) {
                        $this->quote['cost'] = $a_set[$no];
                        break;
                    }
                }
                if (!$this->quote['cost']) {
                    $this->quote['error'] = MODULE_SHIPPING_JPPERCEL_TEXT_OVERSIZE;
                }
                // $this->quote['DEBUG'] = ' DestCountryCode=' . $this->DestCountryCode; //DEBUG
            } else {
				// ºݤˤϵʤϤ
                $this->quote['error'] = MODULE_SHIPPING_JPPERCEL_TEXT_ILLEGAL_AREA . '(' . $this->DestCountryCode .')';
            }
        } else {
            $this->quote['error'] = MODULE_SHIPPING_JPPERCEL_TEXT_OUT_OF_AREA . '(' . $this->DestCountryCode . ')';
        }

        return $this->quote;
    }
}

}
?>