/* **************************************************** gtkdirtreeview.h *** *
 * GtkDirTreeView ءե
 *
 * Copyright (C) 2002 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/02/21 10:46:27 sugaya>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 * ************************************************************************* */
#ifndef	__GTK_DIR_TREE_VIEW_H__
#define	__GTK_DIR_TREE_VIEW_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define	GTK_TYPE_DIR_TREE_VIEW (gtk_dir_tree_view_get_type ())
#define GTK_DIR_TREE_VIEW(obj) (GTK_CHECK_CAST((obj), GTK_TYPE_DIR_TREE_VIEW, GtkDirTreeView))
#define GTK_DIR_TREE_VIEW_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), GTK_TYPE_DIR_TREE_VIEW, GtkDirTreeViewClass))
#define GTK_IS_DIR_TREE_VIEW(obj) (GTK_CHECK_TYPE((obj), GTK_TYPE_DIR_TREE_VIEW))
#define GTK_IS_DIR_TREE_VIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GTK_TYPE_DIR_TREE_VIEW))

typedef struct _GtkDirTreeView		GtkDirTreeView;
typedef struct _GtkDirTreeViewClass	GtkDirTreeViewClass;

struct _GtkDirTreeView {
  GtkTreeView	treeview;
  gchar		*top_path;
  gboolean	show_hidden;
};

struct _GtkDirTreeViewClass {
  GtkTreeViewClass	parent_class;
};

GtkType		gtk_dir_tree_view_get_type	(void);
GtkWidget*	gtk_dir_tree_view_new 		(const gchar	*path,
						 gboolean	show_hidden);
GtkWidget*
gtk_dir_tree_view_new_from_inline (const gchar	*path,
				   gboolean	show_hidden,
				   const guint8	*folder_pixbuf,
				   const guint8	*folder_open_pixbuf,
				   const guint8	*folder_link_pixbuf,
				   const guint8	*folder_link_open_pixbuf,
				   const guint8	*folder_dennied_pixbuf);

GtkWidget*
gtk_dir_tree_view_new_from_file   (const gchar	*path,
				   gboolean	show_hidden,
				   const gchar	*folder_filename,
				   const gchar	*folder_open_filename,
				   const gchar	*folder_link_filename,
				   const gchar	*folder_link_open_filename,
				   const gchar	*folder_dennied_filename);

gboolean
gtk_dir_tree_view_get_show_hidden(GtkDirTreeView	*treeview);
void
gtk_dir_tree_view_set_show_hidden(GtkDirTreeView	*treeview,
				  gboolean		show_hidden);
gchar*
gtk_dir_tree_view_get_selected_path(GtkDirTreeView	*treeview);
void
gtk_dir_tree_view_expand_dir	(GtkDirTreeView		*treeview,
				 const gchar		*dir,
				 gboolean		open_all);
void	gtk_dir_tree_view_set_dir(GtkDirTreeView	*treeview,
				  const gchar		*dir);
void
gtk_dir_tree_view_refresh_tree 	(GtkDirTreeView		*treeview);

void
gtk_dir_tree_view_set_headers_visible (GtkDirTreeView	*treeview,
				       gboolean		headers_visible);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __GTK_DIR_TREE_VIEW_H__ */

/* ********************************************* End of gtkdirtreeview.h *** */
