/* *********************************************************** browser.h *** *
 * ץ إåե
 *
 * Copyright (C) 1998-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/02/23 21:58:00 sugaya>
 * ************************************************************************* */
#ifndef	__BROWSER_H__
#define	__BROWSER_H__

#define	COMBO_LIST_MAX		20

enum {
  BROWSER_MODE_ICON,
  BROWSER_MODE_FILE
};

enum {
  BROWSER_SORT_BY_NAME,
  BROWSER_SORT_BY_FILESIZE,
  BROWSER_SORT_BY_IMAGESIZE,
  BROWSER_SORT_BY_UPDATE
};

typedef struct _TEBrowser {
  GtkWidget	*window;
  GtkWidget	*dir_combo;
  GtkWidget	*dir_tree;
  GtkWidget	*icon_window;
  GtkWidget	*file_window;
  GtkWidget	*iconlist;
  GtkWidget	*filelist;
  GtkWidget	*progressbar;
  GtkWidget	*state_label;
  GList		*combo_list;
  gint		sort_type;
  gint		mode;
  gchar		*selected_dir;
} TEBrowser;

TEBrowser*	ixp_new 		(void);
void		ixp_widget_destroy 	(TEBrowser	*ixp);
void		ixp_combo_list_add 	(TEBrowser	*ixp,
					 GtkWidget	*combo,
					 const gchar	*dir);
void		ixp_scan_dir 		(TEBrowser	*ixp,
					 const gchar	*dir);

#endif	/* __BROWSER_H__ */

/* *********************************************************** browser.h *** */
