/* ************************************************** libteoeyesplugin.h *** *
 * This library is a auxiliary library for teoeyes-plugin programming.
 *
 * Copyright (C) 1998-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-20 23:21:24 sugaya>
 * ************************************************************************* */
#ifndef __LIB_TEOEYES_PLUGIN_H__
#define __LIB_TEOEYES_PLUGIN_H__

#include <gtk/gtk.h>

#define gdk_pixbuf_get_pixel(pixbuf,x,y,p) \
(*(gdk_pixbuf_get_pixels((pixbuf)) + \
 gdk_pixbuf_get_rowstride((pixbuf)) * \
 (y) + gdk_pixbuf_get_n_channels((pixbuf)) * (x) + (p)))

#define gdk_pixbuf_put_pixel(pixbuf,x,y,p,val) \
(*(gdk_pixbuf_get_pixels((pixbuf)) + \
 gdk_pixbuf_get_rowstride((pixbuf)) * \
 (y) + gdk_pixbuf_get_n_channels((pixbuf)) * (x) + (p)) = (val))

typedef void	(*GtkIconItemFactoryCallback)  ();

typedef struct _GtkIconItemFactoryEntry {
  gchar				*path;
  gchar 			*accelerator;
  GtkIconItemFactoryCallback	callback;
  guint		 		callback_action;
  gchar		 		*item_type;
  gconstpointer 		extra_data;
} GtkIconItemFactoryEntry;

typedef struct _PluginInfo {
  GtkIconItemFactoryEntry	menu_item;             /* ˥塼Ѥι¤ */
  gchar				*name;                               /* ̾ */
  gchar				*author;                           /*  */
  gchar				*version;                      /* С */
  gchar				*help;                               /*  */
  gint				active;
  void				(*plugin_func) (GdkPixbuf *,         /* ؿ */
						GdkPixbuf *);
} PluginInfo;   

enum {
  ACTION_NON_INTERACTIVE,
  ACTION_INTERACTIVE
};

enum {
  NON_USE_PROGRESSBAR,	
  USE_PROGRESSBAR	
};

typedef struct {
  GtkWidget		*window;
  GtkWidget		*canvas;
  GtkWidget		*spinbutton;
  GtkWidget		*progressbar;
  GtkWidget		*box;
  GtkAdjustment		*adjuster;
  GdkPixbuf		*src;
  GdkPixbuf		*dst;
  GdkPixbuf		*work;
  int			action;
} PluginDialog;
			     
/* Functions *************************************************************** */
void	plugin_progressbar_update(double			val);

void	plugin_dialog_new	(gchar			*title,
				 void			(*func) 
				 (GdkPixbuf		*src,
				  GdkPixbuf		*dst,
				  double		param1,
				  double		param2,
				  double		param3),
				 GdkPixbuf		*src_img,
				 GdkPixbuf		*dst_img,
				 gchar 			*label,
				 double			min, 
				 double			max,
				 double			step,
				 double			page,
				 int			use_progressbar,
				 int			action);

/* Arguments *************************************************************** */
void	(*plugin_preview_image)	(GdkPixbuf		*src,
				 GdkPixbuf		*dst,
				 double			param1,
				 double			param2,
				 double			param3);

PluginDialog	*db;

#endif	/* __LIB_TEOEYES_PLUGIN_H__ */

/* ********************************************** End of teoeyesplugin.h *** */
