/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef _nsPROCESSWIN_H_
#define _nsPROCESSWIN_H_

#if defined(XP_WIN)
#define PROCESSMODEL_WINAPI
#endif

#include "mozilla/Attributes.h"
#include "mozilla/Mutex.h"
#include "nsIProcess.h"
#include "nsIFile.h"
#include "nsIThread.h"
#include "nsIObserver.h"
#include "nsIWeakReferenceUtils.h"
#include "nsIObserver.h"
#include "nsString.h"
#if 1 // ndef XP_MACOSX // 10.4
#include "prproces.h"
#endif
#if defined(PROCESSMODEL_WINAPI)
#include <windows.h>
#include <shellapi.h>
#endif

#define NS_PROCESS_CID \
{0x7b4eeb20, 0xd781, 0x11d4, \
   {0x8A, 0x83, 0x00, 0x10, 0xa4, 0xe0, 0xc9, 0xca}}

class nsProcess MOZ_FINAL : public nsIProcess,
                            public nsIObserver
{
public:

  NS_DECL_THREADSAFE_ISUPPORTS
  NS_DECL_NSIPROCESS
  NS_DECL_NSIOBSERVER

  nsProcess();

private:
  ~nsProcess();
  static void Monitor(void *arg);
  void ProcessComplete();
  nsresult CopyArgsAndRunProcess(bool blocking, const char** args,
                                 uint32_t count, nsIObserver* observer,
                                 bool holdWeak);
  nsresult CopyArgsAndRunProcessw(bool blocking, const char16_t** args,
                                  uint32_t count, nsIObserver* observer,
                                  bool holdWeak);
  // The 'args' array is null-terminated.
  nsresult RunProcess(bool blocking, char **args, nsIObserver* observer,
                      bool holdWeak, bool argsUTF8);

  PRThread* mThread;
  mozilla::Mutex mLock;
  bool mShutdown;
  bool mBlocking;

  nsCOMPtr<nsIFile> mExecutable;
  nsString mTargetPath;
  int32_t mPid;
  nsCOMPtr<nsIObserver> mObserver;
  nsWeakPtr mWeakObserver;

  // These members are modified by multiple threads, any accesses should be
  // protected with mLock.
  int32_t mExitValue;
#if defined(PROCESSMODEL_WINAPI)
  HANDLE mProcess;
#elif 1 // !defined(XP_MACOSX) // 10.4
  PRProcess *mProcess;
#endif
};

#endif
