/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Gopher Stub Protocol Handler code.
 * The Initial Developer of the Original Code is Cameron Kaiser.
 * Portions created by the Initial Developer are Copyright (C) 2010
 * the Initial Developer. All Rights Reserved.
 *
 * Contributors:
 *   Cameron Kaiser <ckaiser@floodgap.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const Ci = Components.interfaces;
const Cc = Components.classes;
const Cr = Components.results;
const Cu = Components.utils;

Cu.import("resource://gre/modules/XPCOMUtils.jsm");

/* This is a simple module which can be used as a template for any newly
   unsupported protocol. In this case, it redirects gopher:// protocol
   requests to the Mozilla Add-Ons page for OverbiteFF, which is a
   cross-platform extension for Gopherspace. This gives a soft-landing for
   support, which was withdrawn in Mozilla 2.0. See bugs 388195 and 572000. */


function GopherProtocol()
{
}

GopherProtocol.prototype = {
  classDescription : "Gopher protocol handler stub",
  contractID : "@mozilla.org/network/protocol;1?name=gopher",
  classID : Components.ID("{a892e4e0-4dc8-11dd-ae16-0800200c9a66}"),

  // nsISupports
  QueryInterface : XPCOMUtils.generateQI([Ci.nsISupports,
                                          Ci.nsIProtocolHandler]),

  // nsIProtocolHandler
  scheme: "gopher",
  defaultPort: 70,
  protocolFlags: Ci.nsIProtocolHandler.URI_NORELATIVE
    | Ci.nsIProtocolHandler.URI_NOAUTH
    | Ci.nsIProtocolHandler.URI_LOADABLE_BY_ANYONE,
  
  allowPort : function GP_allowPort(port, scheme) {
    return true; // meaningless.
  },

  newURI : function GP_newURI(spec, charset, baseURI) {
    var uri = Cc["@mozilla.org/network/standard-url;1"].
              createInstance(Ci.nsIURI);
    uri.spec = spec;
    return uri;
  },

  newChannel : function GP_newChannel(inputURI) {
    // Create a chrome channel, and de-chrome it, to our information page.
    var chan = Cc["@mozilla.org/network/io-service;1"].
      getService(Ci.nsIIOService).
      newChannel("chrome://global/content/gopherAddon.xhtml", null, null);
    chan.originalURI = inputURI;
    chan.owner = Cc["@mozilla.org/scriptsecuritymanager;1"].
      getService(Ci.nsIScriptSecurityManager).
      getCodebasePrincipal(inputURI);
    return chan;
  }
};

/* Make our factory. */
var components = [ GopherProtocol ];
var NSGetFactory = XPCOMUtils.generateNSGetFactory(components);
