# -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

#ifdef __i386__
#include "os_Darwin_x86.s"
#elif defined(__x86_64__)
#include "os_Darwin_x86_64.s"
#elif defined(__ppc__)
#include "os_Darwin_ppc.s"
#endif

# We're always PPC. So we always compile this.
	.align 5
	.globl _TenFourFoxAtomicSet

# This exactly emulates __sync_lock_test_and_set() on gcc 4.0.1.
# In fact, it's mostly the same code: gcc.gnu.org/ml/gcc/2008-09/msg00038.html
# PRInt32 TenFourFoxAtomicSet(PRInt32 *ptr, PRInt32 value);
# However, the browser does not appear to need any read/write barriers, so
# we observe great justice/performance with this very tight routine.

_TenFourFoxAtomicSet:
	mr r6, r3

tryhardforlock:
	lwarx r3, 0, r6
	stwcx. r4, 0, r6
	bne- tryhardforlock

# leave r3 where it is
	blr

# We want to use the internal atomics wherever possible, because the OS will
# patch out its sync instructions on uniprocessor Macs and internally optimize
# itself. So we don't have an "optimized" routine for add because the internal
# version is always better adapted. (See Mac OS X Internals, p.400.)
