
#include<cstddef>
#include<cmath>
#include<algorithm>
#include<cassert>
#include<tempest/vector/pack_vector.hpp>
namespace tempest{
	
//---------------------------------------------------------------------------
	
namespace {
static const float Table[] =
	{
		0,			0.0890871,	0.125988,	0.154303,	0.178174,	0.199205,	0.218218,	0.235702,	0.251976,	0.267261,	0.281718,	
		0.295468,	0.308607,	0.321208,	0.333333,	0.345033,	0.356348,	0.367315,	0.377964,	0.388322,	0.398410,	0.408248,	
		0.417855,	0.427247,	0.436436,	0.445435,	0.454257,	0.46291,	0.471405,	0.479749,	0.487950,	0.496016,	0.503953,	
		0.511766,	0.519462,	0.527046,	0.534522,	0.541896,	0.54917,	0.556349,	0.563436,	0.570436,	0.577350,	0.584183,	
		0.590937,	0.597614,	0.604218,	0.610750,	0.617213,	0.62361,	0.629941,	0.636209,	0.642416,	0.648564,	0.654654,	
		0.660688,	0.666667,	0.672593,	0.678467,	0.684291,	0.690066,	0.695792,	0.701472,	0.707107,	0.712697,	0.718243,	
		0.723747,	0.729209,	0.734631,	0.740013,	0.745356,	0.750661,	0.755929,	0.761160,	0.766356,	0.771517,	0.776643,	
		0.781736,	0.786796,	0.791823,	0.796819,	0.801784,	0.806718,	0.811622,	0.816497,	0.821342,	0.826160,	0.830949,	
		0.835711,	0.840446,	0.845154,	0.849837,	0.854493,	0.859125,	0.863731,	0.868313,	0.872872,	0.877406,	0.881917,	
		0.886405,	0.890871,	0.895314,	0.899735,	0.904135,	0.908514,	0.912871,	0.917208,	0.921524,	0.925820,	0.930096,	
		0.934353,	0.938591,	0.942809,	0.947009,	0.95119,	0.955353,	0.959497,	0.963624,	0.967733,	0.971825,	0.975900,	
		0.979958,	0.983999,	0.988024,	0.992032,	0.996024,	1,
	};	
}
float SQRTTable126(std::size_t i){
	return ::Table[i];
}

packed_vector16 PackVector16x(float x,float y,float z){
	static const int XSIGN_MASK = 0x8000;//1000,0000,0000,0000
	static const int YSIGN_MASK = 0x4000;//0100,0000,0000,0000
	static const int ZSIGN_MASK = 0x2000;//0010,0000,0000,0000	
	
	#ifdef _DEBUG
		if(x*x+y*y+z*z>1){
			assert("Please use this function for unit vector!");	
		}
	#endif
		
	packed_vector16 out = 0;
	if(x<0){out |= XSIGN_MASK;x*=-1;}
	if(y<0){out |= YSIGN_MASK;y*=-1;}
	if(z<0){out |= ZSIGN_MASK;}
		
	int xbits = static_cast<int>(x*63.0f+0.45f);//0...63
	int ybits = static_cast<int>(y*63.0f+0.45f);//0...63	
		
	return out | ( xbits<<(6) )| ybits;
}

void UnpackVector16x(packed_vector16 val,float *x,float *y,float *z){
	static const int XSIGN_MASK = 0x8000;//1000,0000,0000,0000
	static const int YSIGN_MASK = 0x4000;//0100,0000,0000,0000
	static const int ZSIGN_MASK = 0x2000;//0010,0000,0000,0000	
	static const int  XVAL_MASK = 0x0fc0;//0000,1111,1100,0000
	static const int  YVAL_MASK = 0x003f;//0000,0000,0011,1111
	
	static const double cof = 1.0/63.0;
	
	int xbits = (val&XVAL_MASK)>>6;
	int ybits = (val&YVAL_MASK);
	double xx,yy;
	
	*x = xx = cof*(xbits) 			*	((val&XSIGN_MASK)? -1:1);
	*y = yy = cof*(ybits) 			*	((val&YSIGN_MASK)? -1:1);
	*z = ::std::sqrt(std::max(0.0,1.0-xx*xx-yy*yy) ) 	*	((val&ZSIGN_MASK)? -1:1);		
}

packed_vector32 PackVector32x(float x,float y,float z){
	static const int XSIGN_MASK = 0x80000000;//1000,0000,0000,0000,0000,0000,0000,0000
	static const int YSIGN_MASK = 0x40000000;//0100,0000,0000,0000,0000,0000,0000,0000
	static const int ZSIGN_MASK = 0x20000000;//0010,0000,0000,0000,0000,0000,0000,0000	
	
	#ifdef _DEBUG
		if(x*x+y*y+z*z>1){
			assert("Please use packed_vector for unit vector!");	
		}
	#endif
		
	packed_vector32 out = 0;
	if(x<0){out |= XSIGN_MASK;x*=-1;}
	if(y<0){out |= YSIGN_MASK;y*=-1;}
	if(z<0){out |= ZSIGN_MASK;}
		
	int xbits = static_cast<int>(x*16383.0f+0.45f);//0...16383
	int ybits = static_cast<int>(y*16383.0f+0.45f);//0...16383
		
	return out | ( xbits<<(14) )| ybits;
}

void UnpackVector32x(packed_vector32 val,float *x,float *y,float *z){
	static const int XSIGN_MASK = 0x80000000;//1000,0000,0000,0000,0000,0000,0000,0000
	static const int YSIGN_MASK = 0x40000000;//0100,0000,0000,0000,0000,0000,0000,0000
	static const int ZSIGN_MASK = 0x20000000;//0010,0000,0000,0000,0000,0000,0000,0000	
	static const int  XVAL_MASK = 0x0fffc000;//0000,1111,1111,1111,1100,0000,0000,0000 14bit
	static const int  YVAL_MASK = 0x00003fff;//0000,0000,0000,0000,0011,1111,1111,1111 15bit
	
	static const double cof = 1.0/16383.0;
	
	int xbits = (val&XVAL_MASK)>>14;
	int ybits = (val&YVAL_MASK);
	double xx,yy;
	
	*x = xx = cof*(xbits) 			*	((val&XSIGN_MASK)? -1:1);
	*y = yy = cof*(ybits) 			*	((val&YSIGN_MASK)? -1:1);
	*z = ::std::sqrt(std::max(0.0,1.0-xx*xx-yy*yy) ) 	*	((val&ZSIGN_MASK)? -1:1);		
}
	
	
packed_vector16 PackVector16(float x,float y,float z){
	static const int XSIGN_MASK = 0x8000;//1000,0000,0000,0000
	static const int YSIGN_MASK = 0x4000;//0100,0000,0000,0000
	static const int ZSIGN_MASK = 0x2000;//0010,0000,0000,0000	

	#ifdef _DEBUG
		if(x*x+y*y+z*z>1){
			assert("Please use this function for unit vector!");
		}
	#endif
		
	packed_vector16 out = 0;
	if(x<0){out |= XSIGN_MASK;}
	if(y<0){out |= YSIGN_MASK;}
	if(z<0){out |= ZSIGN_MASK;}
		
	int xbits = static_cast<int>(x*x*126.0f+0.5f);//0...126
	int ybits = static_cast<int>(y*y*126.0f+0.5f);//0...126	
	
	//128/2 = 64
	if(xbits >= 64){
		// 64..xbits..126
		// 62..ybits..  0
		// 126 = xbits+ybits
		xbits = 127 - xbits;// 63...  1
		ybits = 127 - ybits;// 65...127
						    // 128 = xbits+ybits
	}		
		//else 
		//  0..xbits..63
		//  0..ybits..126
		
	return out | ( xbits<<(7) )| ybits;
}

void UnpackVector16(packed_vector16 val,float *x,float *y,float *z){
	static const int XSIGN_MASK = 0x8000;//1000,0000,0000,0000
	static const int YSIGN_MASK = 0x4000;//0100,0000,0000,0000
	static const int ZSIGN_MASK = 0x2000;//0010,0000,0000,0000	
	static const int  XVAL_MASK = 0x1f80;//0001,1111,1000,0000
	static const int  YVAL_MASK = 0x007f;//0000,0000,0111,1111
	
	//static const float cof = 1.0f/126.0f;
	
	int xbits = (val&XVAL_MASK)>>7;
	int ybits = (val&YVAL_MASK);
		
	if( (xbits+ybits) >= 127 ){
			xbits = 127 - xbits;
			ybits = 127 - ybits;			
	}	
	*x = SQRTTable126(xbits) 			*	((val&XSIGN_MASK)? -1:1);
	*y = SQRTTable126(ybits) 			*	((val&YSIGN_MASK)? -1:1);
	*z = SQRTTable126(126-xbits-ybits) 	*	((val&ZSIGN_MASK)? -1:1);		
}

packed_vector32 PackVector32(float x,float y,float z){
	static const int XSIGN_MASK = 0x80000000;//1000,0000,0000,0000,0000,0000,0000,0000
	static const int YSIGN_MASK = 0x40000000;//0100,0000,0000,0000,0000,0000,0000,0000
	static const int ZSIGN_MASK = 0x20000000;//0010,0000,0000,0000,0000,0000,0000,0000	
	//static const int  XVAL_MASK = 0x1fff8000;//0001,1111,1111,1111,1000,0000,0000,0000 14bit
	//static const int  YVAL_MASK = 0x00007fff;//0000,0000,0000,0000,0111,1111,1111,1111 15bit	
	
	#ifdef _DEBUG
		if(x*x+y*y+z*z>1){
			assert("Please use this function for unit vector!");	
		}
	#endif
	
	packed_vector32 out = 0;
	if(x<0){out |= XSIGN_MASK;}
	if(y<0){out |= YSIGN_MASK;}
	if(z<0){out |= ZSIGN_MASK;}
	
	//2^15 = 32768
	//For 7bit integer,which means (32768-1 = 32767).
	//32767-1 = 32766
	int xbits = static_cast<int>(x*x*32766.0f+0.5f);//0...32766
	int ybits = static_cast<int>(y*y*32766.0f+0.5f);//0...32766	
	
	//32768/2 = 16384
	if(xbits >= 16384){
		xbits = 32767 - xbits;
		ybits = 32767 - ybits;
	}		
		
	return out | ( xbits<<(15) )| ybits;	
}

void UnpackVector32(packed_vector32 val,float *x,float *y,float *z){
	static const int XSIGN_MASK = 0x80000000;//1000,0000,0000,0000,0000,0000,0000,0000
	static const int YSIGN_MASK = 0x40000000;//0100,0000,0000,0000,0000,0000,0000,0000
	static const int ZSIGN_MASK = 0x20000000;//0010,0000,0000,0000,0000,0000,0000,0000	
	static const int  XVAL_MASK = 0x1fff8000;//0001,1111,1111,1111,1000,0000,0000,0000 14bit
	static const int  YVAL_MASK = 0x00007fff;//0000,0000,0000,0000,0111,1111,1111,1111 15bit	
	
	static const double cof = 1.0/32766.0;
	
	int xbits = (val&XVAL_MASK)>>15;
	int ybits = (val&YVAL_MASK);
		
	if( (xbits+ybits) >= 32767 ){
			xbits = 32767 - xbits;
			ybits = 32767 - ybits;			
	}	
	*x = ::std::sqrt(xbits * cof) 				*	((val&XSIGN_MASK)? -1:1);
	*y = ::std::sqrt(ybits * cof) 				*	((val&YSIGN_MASK)? -1:1);
	*z = ::std::sqrt( (32766-xbits-ybits) * cof )	*	((val&ZSIGN_MASK)? -1:1);		
}



}


