#include "../vector/matrix3.hpp"
#include "../vector/matrix4.hpp"
#include "../vector/matrix_generator.hpp"
#include "../vector/sse_vector.hpp"
#include "../vector/sse_matrix.hpp"
#include "../vector/sse_transform.hpp"
#include <xmmintrin.h>
#include <iostream>
#include <iterator>

#define IOF(m,i) reinterpret_cast<float*>(&(m))[i]
#define CIOF(m,i) reinterpret_cast<const float*>(&(m))[i]


inline __m128 __CVT424(__m128 a,__m128 b,__m128 c,__m128 d){
	return _mm_setr_ps(CIOF(a,0),CIOF(b,1),CIOF(c,2),CIOF(d,3));
}

using namespace tempest;



float f(float * array){
	__m128 sx;
	float aaa[] = {0,1,2,3};
	float bbb[] = {4,5,6,7};
	float ccc[] = {8,9,10,11};
	float ddd[] = {12,13,14,15};
	
	__m128 ax = _mm_loadu_ps(aaa);
	__m128 bx = _mm_loadu_ps(bbb);
	__m128 cx = _mm_loadu_ps(ccc);
	__m128 dx = _mm_loadu_ps(ddd);
	
	sse_matrix ssem(ax,bx,cx,dx);
	sse_vector ssev(ax);
	
	std::cout << ssem*ssev <<"---"<<std::endl;//14 38 62 86 
	std::cout << ssev*ssem <<"---"<<std::endl;//4+16+36 = 56
	
	std::cout << _mm_shuffle_ps(ax,bx,_MM_SHUFFLE(2,2,0,0)) <<std::endl;
	
	
	std::cout << __CVT424(ax,bx,cx,dx) <<std::endl;
	
	sx = _mm_loadu_ps(aaa);
	std::cout << sx <<std::endl;
	
	sx = _mm_setr_ps(0,1,2,3);
	
	std::cout << sx <<std::endl;
	
	float f = CIOF(sx,0); 
	std::cout << f <<std::endl;
													//01
	std::cout << _mm_shuffle_ps(sx,sx,_MM_SHUFFLE(1,0,3,2)) << std::endl;
	
	typedef tempest::matrix<float,4,4> MAT;
	
	float aa[16];
	typedef tempest::matrix_generator<MAT> MATGEN;
	
	MAT mr = MATGEN::rotation_x(1.0/4 *3.1415)*MATGEN::scaling(2,2,2)*MATGEN::translation(2,2,2);
	

	std::copy(mr.begin(),mr.end(),aa);		

	//std::copy(aa,aa+16,std::ostream_iterator<char>(std::cout,","));
	
	
	MAT m(aa);
	std::cout << m <<"jdskjfkjsadgjlksdf"<<std::endl;
	
	std::cout << m.det() <<std::endl;
	
	sse_matrix mm(aa);
	std::cout << mm <<std::endl;
	
	std::cout << mm.det() <<std::endl;
	
	
	float rs[] = {1,1,1,1};
	
	sse_vector s1(rs);
	sse_vector s2 = -sse_vector(2,4,8,16);
	sse_vector s3 = +sse_vector(4,5,7,9);
	
	std::cout << (s1) << std::endl;
	std::cout << (s2) << std::endl;
	std::cout << (s3) << std::endl;
	
	s2[2] = 100;
	
	sse_vector sout = (s2+s3/s1-s2);
	std::cout << "----" << std::endl;
	//s1 /= s3;
	std::cout << sout <<"mkljmkl"<< std::endl;
	
	//const float rs[] = {11,22,33,44};
	
	__m128 m1 = _mm_setr_ps(1,2,3,4);						//4,3,2,1 1234
	__m128 m3 = _mm_shuffle_ps(m1,m1,_MM_SHUFFLE(1,0,3,2));	//2,1,4,3 3434
	m3 = _mm_add_ps(m1,m3);									//6,4,6,4 4668 
	m1 = _mm_shuffle_ps(m3,m3,_MM_SHUFFLE(2,3,0,1));		//4,6,4,6 6666
	m3 = _mm_add_ps(m1,m3);									//10101010
	
	
	std::cout << "----" << std::endl;
	sse_vector out;
	out = m3;//_mm_shuffle_ps(m3,m3,0);
	//out = (s1*s2+s3);
	//
	float ff = out[0];
	
	return 1;
}

int main(){
	//const float rs[] = {1,2,3,4};
	float rs[4];
	//sse_vector s2 = sse_vector(1,3,5,6);
	//sse_vector s3 = sse_vector(4,5,7,9);
	for(int i = 0; i<4;i++){
		rs[i] = -i;
	}

	
	sse_vector out;
	
	//std::cout << out << std::endl;
	//out = s1+s2+s3;
	//float f = out[1];
	//const float f2 = 2;
	//double d = f;
	f(rs);
	//for(int i = 0; i<4;i++){
	//	std::cout << rs[i] << std::endl;
	//}
	

}





