#include "../vector/matrix4.hpp"
#include <iostream>
#include <limits>

bool isnan(double d){ return !(d >= 0.0) && !(d < 0.0); }
bool isnan(double d){ return !(d == d); }

int main(){
	typedef tempest::matrix<double,5,5> MAT;
	
	double a[] = {
		0,1,0,0,0,
		1,0,1,0,1,
		0,1,0,1,1,
		0,0,1,0,2,
		0,1,1,2,0
	};
	
	MAT m(a);
	MAT m2 = m*m;
	MAT m3 = m*m*m;
	MAT s2 = m+m2;
	MAT s3 = m+m2+m3;
	
	std::cout << m2 << std::endl;
	std::cout << m3 << std::endl;
	
	std::cout << s2 << std::endl;
	std::cout << s3 << std::endl;
	
	float f = std::numeric_limits<float>::quiet_NaN();
	float f2 = 0.0f/0.0f;
	float f3 = 1/0.0f;
	float f4 = -2/0.0f;
	
	std::cout << isnan( 0) << std::endl;
	std::cout << isnan(-0) << std::endl;
	std::cout << isnan(f3) << std::endl;
	std::cout << isnan(f4) << std::endl;
	std::cout << isnan(f) << std::endl;
	std::cout << isnan(f2) << std::endl;
	std::cout << isnan(f3+f4) << std::endl;
	std::cout << "-------" << std::endl;
	std::cout << isnan_x( 0) << std::endl;
	std::cout << isnan_x(-0) << std::endl;
	std::cout << isnan_x(f3) << std::endl;
	std::cout << isnan_x(f4) << std::endl;
	std::cout << isnan_x(f) << std::endl;
	std::cout << isnan_x(f2) << std::endl;
	std::cout << isnan_x(f3+f4) << std::endl;
	
}

