#ifndef _TMMATRIX_BASE_FUNCTIONS_HPP
#define _TMMATRIX_BASE_FUNCTIONS_HPP

/** 
 *  @file vector_base_functions.hpp
 *  @brief Defines functions for tempest::matrix_base<Self,Type,RowSz,ColumnSz>.
 *  @author ototoi / Toru Matsuoka
 *  @date 2004/07/14 
 */

#include <cstddef>
#include "matrix_base.hpp"

namespace tempest{
	
//if true definition matrix invert function using by LU separate method.
#if 0
template<class Self, class T, std::size_t Sz>
bool lu_separate(matrix_base<Self,T,Sz,Sz> * out, std::size_t * index){ /* LU */
	std::size_t i, j, k, ii, ik;
	T t, u, det;
	
	if(out == 0)return 0;
	Self & a = static_cast<Self&>(*out);
	
	T buffer[Sz];//line
	
	det = 0;                   //det
	for (k = 0; k < Sz; k++) {  //row
		index[k] = k;             //
		u = 0;                 //max
		for (j = 0; j < Sz; j++) {
			t = fabs(a[k][j]);  if (t > u) u = t;
		}
		if (u == 0) return false; 
		buffer[k] = 1 / u;     //
	}
	
	det = 1;                   //
	
	for (k = 0; k < Sz; k++) {  //
		u = -1;
		for (i = k; i < Sz; i++) {  //less under 
			ii = index[i];            //
			t = fabs(a[ii][k]) * buffer[ii];
			if (t > u) {  u = t;  j = i;  }
		}
		
		ik = index[j];
		
		if (j != k) {
			index[j] = index[k];  index[k] = ik;  	//swap
			det = -det;  							//chage sign
		}
		
		u = a[ik][k];  det *= u;  
		
		if (u == 0)return false;    
		for (i = k + 1; i < Sz; i++) {  
			ii = index[i];
			t = (a[ii][k] /= u);
			for (j = k + 1; j < Sz; j++)
				a[ii][j] -= t * a[ik][j];
		}
	}

	return (det != 0);           
}
	
template<class Self, class T, std::size_t Sz> //lu
bool invert (matrix_base<Self,T,Sz,Sz> *out, const matrix_base<Self,T,Sz,Sz> &rhsx){
	int i, j, k, ii;
	T t, det;
	
	std::size_t index[Sz];
	
	if(out == 0){
		return false;
	}
	
	const Self & rhs = static_cast<const Self&>(rhsx);	
	Self a(rhs);
	Self & a_inv = static_cast<Self&>(*out);
	
	if( !lu_separate(&a, index) )return false;
	
	for (k = 0; k < Sz; k++) {
		for (i = 0; i < Sz; i++) {
			ii = index[i];  t = (ii == k);
			for (j = 0; j < i; j++)
				t -= a[ii][j] * a_inv[j][k];
			a_inv[i][k] = t;
		}
		for (i = Sz - 1; i >= 0; i--) {
			t = a_inv[i][k];  ii = index[i];
			for (j = i + 1; j < Sz; j++)
				t -= a[ii][j] * a_inv[j][k];
			a_inv[i][k] = t / a[ii][i];
		}
	}
	
	return true;
}

#else
	
template<class Self, class T, std::size_t Sz> //gauss joldan
bool invert (matrix_base<Self,T,Sz,Sz> *out, const matrix_base<Self,T,Sz,Sz> &rhsx){
	std::size_t i, j, k;
	T t, u, det;
	
	if(out == 0){
		return false;
	}
	
	const Self & rhs = static_cast<const Self&>(rhsx);
	Self & a = static_cast<Self&>(*out);
	
	a = rhs;	

	det = T(1);
	for (k = 0; k < Sz; k++) {
		t = a[k][k];  det *= t;
		for (i = 0; i < Sz; i++) a[k][i] /= t;
		a[k][k] = T(1) / t;
		for (j = 0; j < Sz; j++){
			if (j != k) {
				u = a[j][k];
				for (i = 0; i < Sz; i++)
					if (i != k) a[j][i] -= a[k][i] * u;
					else        a[j][i] = -u / t;
			}
		}
		
	}
	
	if(det != T(0))return true;
	else return false;
	//return det;
}
	
#endif
	
	
//-----------------------------------------------
//output

/** 
 * ostream << 
 */
template<class Self, typename T, std::size_t RowSz, std::size_t ColumnSz, typename _CharT, class _Traits>
std::basic_ostream<_CharT, _Traits>& operator<<(std::basic_ostream<_CharT, _Traits>& os,  const matrix_base<Self, T,RowSz,ColumnSz>& rhsx){
	const Self & rhs = static_cast<const Self &>(rhsx);
	
	std::basic_ostringstream<_CharT, _Traits> s;
	s.flags(os.flags());
	s.imbue(os.getloc());
	s.precision(os.precision());
	s << "(";
	for(std::size_t i=0;i<RowSz;i++){
		s <<"(";
		for(std::size_t j = 0;j < ColumnSz;++j){
			s << rhs[i][j];
			if(j != ColumnSz-1){s << ",";}
		}
		s <<")";
		if(i != RowSz-1){s << ",";}
	}		
	s << ")";
	return os << s.str();
}

	
}

#endif

