#ifndef _TM_TYPE_TRAITS_HPP
#define _TM_TYPE_TRAITS_HPP


#include <limits>



namespace tempest{
	
	template<class T>
	struct is_float{static const bool value = false;};
	
	template<>
	struct is_float<float>{static const bool value = true;};
	
	template<>
	struct is_float<double>{static const bool value = true;};
	
	template<>
	struct is_float<long double>{static const bool value = true;};
	
	
	template<class T>
	struct is_arith{
		static const bool value = std::numeric_limits<T>::is_integer|is_float<T>::value;
	};
	
	template<class T,bool is_param = false>
	struct param_type_imp{
		typedef const T& type;	
	};
	
	template<class T>
	struct param_type_imp<T,true>{
		typedef T type;	
	};		
	
	template<class T>
	struct param_type{
		typedef typename param_type_imp<T,is_arith<T>::value>::type type; 
	};
	

}

#endif

