#ifndef _TMC_VECTOR_HPP
#define _TMC_VECTOR_HPP

namespace tempest{
namespace cv{
	
template<int ELM,class NEXT>
class cv_t{
public:
	enum{value =  ELM};
	typedef NEXT next;	
};
	
class nil{};//terminator
	
template<class VECTOR>
class sum{
public:
	enum{value = VECTOR::value + sum<typename VECTOR::next>::value};		
};
	
template<>
class sum<nil>{
public:
	enum{value = 0};		
};
	
template<class VECTOR>
class size{
public:
	enum{value = 1+length<typename VECTOR::next>::value};		
};
	
template<>
class size<nil>{
public:
	enum{value = 0};		
};
	
template<class VECTOR, int ELM>
class append{
public:
	typedef type cv_t<VECTOR::value,typename append<typename VECTOR::next,ELM>::type>;
};
	
template<int ELM>
class append<nil,ELM>{
public:
	typedef type cv_t<ELM,nil>;
};
	
templae<class VECTOR, int INDEX>
class index{
public:
	enum{value = index<VECTOR,INDEX-1>::value};
};

template<class VECTOR>
class index<VECTOR,0>{
public:
	enum{value = VECTOR::value};
};
	
template<class V1, class V2>
class dot{
public:
	enum{value = (V1::value * V2::value)+dot<V1::next,V2::next>::value};
};
	
template<>
class dot<nil,nil>{
public:
	enum{value = 0};
};
	
template<class V1>
class length{
public:
	enum{value = dot<V1,V1>::value};
};
	
template<class V1, class V2>
class plus{
public:
	enum{value = V1::value + V2::value};
	typedef plus<typename V1::next,typename V2::next> next;
};

template<class V1, class V2>
class minus{
public:
	enum{value = V1::value - V2::value};
	typedef minus<typename V1::next,typename V2::next> next;
};
	
template<class V1, class V2>
class multiply{
public:
	enum{value = V1::value * V2::value};
	typedef multiply<typename V1::next,typename V2::next> next;
};
	
template<class V1, class V2>
class divide{
public:
	enum{value = V1::value / V2::value};
	typedef divide<typename V1::next,typename V2::next> next;
};
	
template<class V1, class V2>
class mod{
public:
	enum{value = V1::value % V2::value};
	typedef mod<typename V1::next,typename V2::next> next;
};
	

	
template<class T>
class byte2int32{
public:
	enum{shift_size = 8*sizeof(int)/4};//32/4=8
	enum{
		a = (0xff & index<T,0>::value)<<(3*shift_size),
		b = (0xff & index<T,1>::value)<<(2*shift_size),
		c = (0xff & index<T,2>::value)<<(1*shift_size),
		d = (0xff & index<T,3>::value)	
	};
	enum{value = a | b | c | d};	
};
	
}//cv
}//tempest

#define TEMC ::tempest::cv

#define MAKE_CV(a)   TEMC::cv_t< a, TEMC::nil >//
#define MAKE_CV_1(a) TEMC::cv_t< a, TEMC::nil >
#define MAKE_CV_2(a,b) TEMC::cv_t< a, MAKE_CV_1(b) >
#define MAKE_CV_3(a,b,c) TEMC::cv_t< a, MAKE_CV_2(b,c) >
#define MAKE_CV_4(a,b,c,d) TEMC::cv_t< a, MAKE_CV_3(b,c,d) >
#define MAKE_CV_5(a,b,c,d,e) TEMC::cv_t< a, MAKE_CV_4(b,c,d,e) >

//
#define APPEND_CV(a,b) typename TEMC::append<a,b>::type
#define INDEX_CV(a,b) TEMC::index<a,b>::value
#define SIZE_CV(a) TEMC::size<a>::value
#define SUM_CV(a) TEMC::sum<a>::value
#define DOT_CV(a,b) TEMC::dot<a,b>::value
#define LENGTH_CV(a) TEMC::length<a>::value

//
#define PLUS_CV(a,b) TEMC::plus<a,b>
#define MINUS_CV(a,b) TEMC::minus<a,b>
#define MUL_CV(a,b) TEMC::multiply<a,b>
#define DIV_CV(a,b) TEMC::divide<a,b>

//
define BYTE2INT32(a,b,c,d) TEMC::byte2int32< MAKE_CV_4(a,b,c,d) >::value 




#endif

