#include"../vector/vector.hpp"
#include"../vector/vector4.hpp"
#include"../vector/vector3.hpp"
#include"../vector/vector2.hpp"
#include"../vector/safety_vector.hpp"

#include<cstring>

#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include <cppunit/ui/text/TestRunner.h>
#include <cppunit/TextOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>


#include<iostream>

using namespace std;

class VectorTest : public CppUnit::TestFixture {
	CPPUNIT_TEST_SUITE(VectorTest); // [4]
		CPPUNIT_TEST(testStyle);      // [5]
		CPPUNIT_TEST(testOperation);
	
	CPPUNIT_TEST_SUITE_END();    // [4]	
public:
	virtual void setUp() {}
	virtual void tearDown() {}	
public:
	void testStyle();
	void testOperation();

private:
	typedef tempest::vector<double ,2> V2;
	typedef tempest::vector<double ,3> V3;
	typedef tempest::vector<double ,4> V4;
	typedef tempest::vector<double ,5> V5;
	typedef tempest::safety_vector<double ,3> SV;
	
	SV sv;
	
	V2 v2;
	V3 v3;
	V4 v4;
	V5 v5;
};
/*
CPPUNIT_ASSERT( condition );
conditionU(false,0)łƂAs܂B

CPPUNIT_ASSERT_MESSAGE( message, condition );
conditionUłƂAs܂B̂Ƃmessageo͂܂B

CPPUNIT_FAIL( message );
Ks܂Bmessageo͂܂B

CPPUNIT_ASSERT_EQUAL( expected, actual );
ꂽactual҂lexpectedłȂƂAȂ킿expected != actual̂ƂɎs܂B

CPPUNIT_ASSERT_EQUAL_MESSAGE( message, expected, actual );
ꂽactual҂lexpectedłȂƂAȂ킿expected != actual̂ƂɎs܂B̂Ƃmessageo͂܂B

CPPUNIT_ASSERT_DOUBLES_EQUAL( expected, actual, delta );
ꂽactualƊ҂lexpectedƂ̍delta傫ƂAs܂B
*/

void VectorTest::testStyle(){	
	CPPUNIT_ASSERT(strcmp( v2.debug(), "tempest::vector<T,2>" ) == 0);
	CPPUNIT_ASSERT(strcmp( v3.debug(), "tempest::vector<T,3>" ) == 0);
	CPPUNIT_ASSERT(strcmp( v4.debug(), "tempest::vector<T,4>" ) == 0);
	CPPUNIT_ASSERT(strcmp( v5.debug(), "tempest::vector<T,Sz>" ) == 0);
	CPPUNIT_ASSERT(strcmp( sv.debug(), "tempest::safety_vector<T,Sz>" ) == 0);
}
//-------------------//
void VectorTest::testOperation(){
	double arrays[4][3] = {{1,2,3},{4,5,6},{7,8,9},{10,11,12}};
	double outs[3];
	for(int  i = 0;i<3;i++){
		outs[i] = arrays[0][i]+arrays[1][i]*arrays[2][i]/arrays[3][i];
	}
	
	double array5[4][5] = {{1,2,3,4,5},{6,7,8,9,10},{11,12,13,14,15},{16,17,18,19,20} };
	double out5[5];
	for(int  i = 0;i<5;i++){
		out5[i] = array5[0][i]+array5[1][i]*array5[2][i]/array5[3][i];
	}
	
	CPPUNIT_ASSERT_EQUAL( (V2(1,2)+V2(3,4)*V2(5,6)/V2(7,8)) , V2(1+3*5/7.,2+4*6/8.) );
	CPPUNIT_ASSERT_EQUAL( (V3(1,2,3)+V3(4,5,6)*V3(7,8,9)/V3(10,11,12)) , V3(1+4*7/10.,2+5*8/11.,3+6*9/12.) );
	CPPUNIT_ASSERT_EQUAL( (V4(1,2,3,4)+V4(5,6,7,8)*V4(9,10,11,12)/V4(13,14,15,16)) , V4(1+5*9/13.,2+6*10/14.,3+7*11/15.,4+8*12/16.) );
	CPPUNIT_ASSERT_EQUAL( (V5(array5[0])+V5(array5[1])*V5(array5[2])/V5(array5[3])) , V5(out5) );
	CPPUNIT_ASSERT_EQUAL( (SV(arrays[0])+SV(arrays[1])*SV(arrays[2])/SV(arrays[3])) , SV(outs) );
	
	CPPUNIT_ASSERT_EQUAL( (V2(1,2)+V2(3,4)*V2(5,6)/V2(7,8)).length() ,  V2(1+3*5/7.,2+4*6/8.).length() );
	CPPUNIT_ASSERT_EQUAL( (V3(1,2,3)+V3(4,5,6)*V3(7,8,9)/V3(10,11,12)).length() , V3(1+4*7/10.,2+5*8/11.,3+6*9/12.).length() );
	CPPUNIT_ASSERT_EQUAL( (V4(1,2,3,4)+V4(5,6,7,8)*V4(9,10,11,12)/V4(13,14,15,16)).length() , V4(1+5*9/13.,2+6*10/14.,3+7*11/15.,4+8*12/16.).length() );	
	CPPUNIT_ASSERT_EQUAL( (V5(array5[0])+V5(array5[1])*V5(array5[2])/V5(array5[3])).length() , V5(out5).length() );
	CPPUNIT_ASSERT_EQUAL( (SV(arrays[0])+SV(arrays[1])*SV(arrays[2])/SV(arrays[3])).length() , SV(outs).length() );
	
	CPPUNIT_ASSERT_DOUBLES_EQUAL(1.0, (V2(1,2)+V2(3,4)*V2(5,6)/V2(7,8)).normalize().length()  ,0.0001);
	CPPUNIT_ASSERT_DOUBLES_EQUAL(1.0, (V3(1,2,3)+V3(4,5,6)*V3(7,8,9)/V3(10,11,12)).normalize().length() ,0.0001);
	CPPUNIT_ASSERT_DOUBLES_EQUAL(1.0, (V4(1,2,3,4)+V4(5,6,7,8)*V4(9,10,11,12)/V4(13,14,15,16)).normalize().length()  ,0.0001);	
	CPPUNIT_ASSERT_DOUBLES_EQUAL(1.0, (V5(array5[0])+V5(array5[1])*V5(array5[2])/V5(array5[3])).normalize().length()  ,0.0001);
	CPPUNIT_ASSERT_DOUBLES_EQUAL(1.0, normalize(SV(arrays[0])+SV(arrays[1])*SV(arrays[2])/SV(arrays[3])).length()  ,0.0001);
}




CPPUNIT_TEST_SUITE_REGISTRATION(VectorTest);

int main() {
	CppUnit::TextUi::TestRunner runner;
	runner.addTest(CppUnit::TestFactoryRegistry::getRegistry().makeTest());
	CppUnit::Outputter* outputter = new CppUnit::TextOutputter(&runner.result(),std::cout);
	runner.setOutputter(outputter);
	return runner.run() ? 0 : 1;
}

