

#include<iostream>
#include<string>
#include <assert.h>
#include <vector>
#include <list>
#include <algorithm>
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <typeinfo>

#include "../pointer/slisted_ptr.hpp"
#include "../pointer/dlisted_ptr.hpp"
#include "../pointer/linked_ptr.hpp"
#include "../pointer/counted_ptr.hpp"

#include <boost/shared_ptr.hpp>
/*
class B 
{
public:

   B() : val( rand() ) {}
   bool operator<( const B & other ) const { return val < other.val; }

private:

   int val;
};
*/
struct B{};


using namespace tempest;
using namespace std;
using namespace boost;

void test_data_sizes()
{
   std::cout << "sizeof( B* )"          << sizeof ( B*          ) << std::endl;
   std::cout << "sizeof( slisted_ptr<B> )"       << sizeof ( slisted_ptr<B>       ) << std::endl;
   std::cout << "sizeof( dlisted_ptr<B> )"    << sizeof ( dlisted_ptr<B>    ) << std::endl;
   std::cout << "sizeof( linked_ptr<B> )" << sizeof ( smart_pointers::linked_ptr<B> ) << std::endl;
   std::cout << "sizeof( counted_ptr<B> )" << sizeof ( counted_ptr<B> ) << std::endl;	
   std::cout << "sizeof( shared_ptr<B> )"          << sizeof ( shared_ptr<B>          ) << std::endl;
}

int main(int argc, char** argv) {
	
	test_data_sizes();
	
   srand( (unsigned)time( NULL ) );
   const int N = 300000;
   //const int N = atoi(argv[1]);

   	//typedef B* ptr_int;
   	//typedef slisted_ptr<B> ptr_int;
	//typedef dlisted_ptr<B> ptr_int;
	//typedef smart_pointers::linked_ptr<B> ptr_int;
	typedef counted_ptr<B> ptr_int;
	//typedef shared_ptr<B> ptr_int;
	
   printf( "Testing %s\n", typeid(ptr_int).name() );

   {  clock_t start = clock();
      vector<ptr_int> container;
      for (int i = 0; i < N; i++ )
         container.push_back(ptr_int(new B()));
      printf("fill vector: %ld\n",(long)clock() - start);
      sort(container.begin(), container.end());
      printf("sort vector: %ld\n",(long)clock() - start);
   }
   {  clock_t start = clock();
      list<ptr_int> container;
      for (int i = 0; i < N; i++ )
         container.push_back(ptr_int(new B()));
      printf("fill list: %ld\n",(long)clock() - start);
      container.sort();
      printf("sort list: %ld\n",(long)clock() - start);
   }
   return 0;
}
