#ifndef _TMBIT_VECTOR_HPP
#define _TMBIT_VECTOR_HPP
/** 
	@file bit_vector.hpp
	@brief Defines tempest::vector<T,Sz>.
	@author ototoi / Toru Matsuoka
	@date 2004/05/15 
*/

//-----------------------------------------------
#include<cstddef>//std::size_t
#include<cmath>//std::sqrt
#include<algorithm>//copy
#include<stdexcept>

#include"vector.hpp" //For static polimorphizm.


//_TEMPEST_USE_META_
//_TEMPEST_USE_FASTMATH_
#define std::size_t BITSTYPE

namespace tempest{
	
template<std::size_t Sz>
class bit_vector{
public:
	typedef bool value_type;
    typedef size_t size_type;
    typedef ptrdiff_t difference_type; 
    //typedef _Bit_reference reference;
    typedef bool const_reference;
    //typedef _Bit_reference* pointer;
    typedef const bool* const_pointer;
	
	typedef bit_vector<Sz> this_type;
	
	static const num = Sz/8 + Sz%8;
public:
	bit_vector(){}
	bit_vector(const this_type& rhs):element(rhs.element){}
	
	
private:
	struct{
		BITSTYPE m[];
	}element;
};

}//End of namespace.
	
#include "vector_functions.hpp"

#endif

