/*
 * Decompiled with CFR 0.152.
 */
package goooooooooosuke.tddsupport.plugin;

import goooooooooosuke.tddsupport.plugin.NamingRules;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairMethodFinder {
    private NamingRules namingRules;

    public PairMethodFinder(NamingRules namingRules) {
        this.namingRules = namingRules;
    }

    public boolean isTestMethod(IMethod target) {
        int i = 0;
        while (i < this.namingRules.size()) {
            String namingRule = this.namingRules.get(i);
            namingRule = namingRule.replaceAll("\\$\\{method\\}", "\\\\w+");
            namingRule = namingRule.replaceAll("\\$\\{any\\}", "\\\\w+");
            if (target.getElementName().matches(this.escapeForRegExp(namingRule))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List<IMethod> findPairMethod(IMethod target, IType type) throws JavaModelException {
        ArrayList<IMethod> pairMethodList = new ArrayList<IMethod>();
        List<String> pairMethodNameList = this.getPairMethodNameList(target);
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            for (String pairMethodName : pairMethodNameList) {
                if (method.isConstructor()) {
                    char[] chars = pairMethodName.toCharArray();
                    chars[0] = Character.toUpperCase(chars[0]);
                    pairMethodName = new String(chars);
                }
                if (!method.getElementName().equals(pairMethodName)) continue;
                pairMethodList.add(method);
            }
            ++n2;
        }
        return pairMethodList;
    }

    public List<IMethod> findPairTestMethod(IMethod target, IType type) throws JavaModelException {
        ArrayList<IMethod> pairTestMethodList = new ArrayList<IMethod>();
        List<String> pairTestMethodNameList = this.getPairTestMethodNameList(target);
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            for (String pairTestMethodName : pairTestMethodNameList) {
                pairTestMethodName = pairTestMethodName.replaceAll("\\$\\{any\\}", "(\\\\w+)");
                if (!method.getElementName().matches(this.escapeForRegExp(pairTestMethodName))) continue;
                pairTestMethodList.add(method);
            }
            ++n2;
        }
        return pairTestMethodList;
    }

    private List<String> getPairMethodNameList(IMethod target) {
        ArrayList<String> pairMethodNameList = new ArrayList<String>();
        String methodName = target.getElementName();
        int i = 0;
        while (i < this.namingRules.size()) {
            String namingRule = this.namingRules.get(i);
            String testUnderMethodName = this.getTestUnderMethodName(target, namingRule);
            if (testUnderMethodName != null) {
                String testMethodName = namingRule.replaceAll("\\$\\{method\\}", this.escapeForRegExp(testUnderMethodName));
                if (methodName.matches(this.escapeForRegExp(testMethodName = testMethodName.replaceAll("\\$\\{any\\}", "\\\\w+")))) {
                    char[] chars = testUnderMethodName.toCharArray();
                    chars[0] = Character.toLowerCase(chars[0]);
                    pairMethodNameList.add(new String(chars));
                }
            }
            ++i;
        }
        return pairMethodNameList;
    }

    private List<String> getPairTestMethodNameList(IMethod target) {
        ArrayList<String> pairTestMethodNameList = new ArrayList<String>();
        String methodName = target.getElementName();
        int i = 0;
        while (i < this.namingRules.size()) {
            String pairMethodName = this.namingRules.get(i);
            if (pairMethodName.startsWith("${method}")) {
                pairMethodName = pairMethodName.replaceAll("\\$\\{method\\}", this.escapeForRegExp(methodName));
            } else {
                char[] chars = methodName.toCharArray();
                chars[0] = Character.toUpperCase(chars[0]);
                pairMethodName = pairMethodName.replaceAll("\\$\\{method\\}", this.escapeForRegExp(new String(chars)));
            }
            pairTestMethodNameList.add(pairMethodName);
            ++i;
        }
        return pairTestMethodNameList;
    }

    private String getTestUnderMethodName(IMethod target, String namingRule) {
        String testUnderMethodName = null;
        namingRule = namingRule.replaceAll("\\$\\{method\\}", "(\\\\w+)");
        Pattern p = Pattern.compile(this.escapeForRegExp(namingRule = namingRule.replaceAll("\\$\\{any\\}", "\\\\w+")));
        Matcher m = p.matcher(target.getElementName());
        if (m.matches()) {
            testUnderMethodName = m.group(1);
        }
        return testUnderMethodName;
    }

    private String escapeForRegExp(String value) {
        return value.replaceAll("\\$", "\\\\\\$").replaceAll("\\.", "\\\\\\.");
    }

    public IMethod getCreationTestMethod(IMethod target, IType type) {
        String creationMethodName = this.getPairTestMethodNameList(target).get(0);
        return type.getMethod(creationMethodName, null);
    }
}

