/*
 * Decompiled with CFR 0.152.
 */
package goooooooooosuke.tddsupport.plugin;

import goooooooooosuke.tddsupport.plugin.NamingRules;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairClassFinder {
    private String javaSrcFolder;
    private String testSrcFolder;
    private NamingRules namingRules;

    public String getJavaSrcFolder() {
        return this.javaSrcFolder;
    }

    public String getTestSrcFolder() {
        return this.testSrcFolder;
    }

    public PairClassFinder(String javaSrcFolder, String testSrcFolder, NamingRules namingRules) {
        this.javaSrcFolder = javaSrcFolder;
        this.testSrcFolder = testSrcFolder;
        this.namingRules = namingRules;
    }

    public boolean isTestClass(IType target) {
        if (!this.exists(this.testSrcFolder, target)) {
            return false;
        }
        String packageName = target.getPackageFragment().getElementName();
        int i = 0;
        while (i < this.namingRules.size()) {
            String namingRule = this.namingRules.get(i);
            namingRule = namingRule.replaceAll(packageName.length() == 0 ? "\\$\\{package\\}\\.?" : "\\$\\{package\\}", this.escapeForRegExp(packageName));
            namingRule = namingRule.replaceAll("\\$\\{class\\}", "\\\\w+");
            if (target.getFullyQualifiedName().matches(this.escapeForRegExp(namingRule))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List<IType> findPairClass(IType target) throws JavaModelException {
        ArrayList<IType> pairClassList = new ArrayList<IType>();
        List<String> pairClassNameList = this.getPairClassNameList(target);
        for (String pairClassName : pairClassNameList) {
            IType pairClass = target.getJavaProject().findType(pairClassName);
            if (pairClass == null || !this.exists(this.javaSrcFolder, pairClass)) continue;
            pairClassList.add(pairClass);
        }
        return pairClassList;
    }

    public List<IType> findPairTestClass(IType target) throws JavaModelException {
        ArrayList<IType> pairClassList = new ArrayList<IType>();
        List<String> pairClassNameList = this.getPairTestClassNameList(target);
        for (String pairClassName : pairClassNameList) {
            IType pairClass = target.getJavaProject().findType(pairClassName);
            if (pairClass == null || !this.exists(this.testSrcFolder, pairClass)) continue;
            pairClassList.add(pairClass);
        }
        return pairClassList;
    }

    private List<String> getPairTestClassNameList(IType target) {
        ArrayList<String> pairTestClassNameList = new ArrayList<String>();
        String packageName = target.getPackageFragment().getElementName();
        String className = target.getElementName();
        int i = 0;
        while (i < this.namingRules.size()) {
            String pairClassName = this.namingRules.get(i);
            pairClassName = pairClassName.replaceAll(packageName.length() == 0 ? "\\$\\{package\\}\\.?" : "\\$\\{package\\}", this.escapeForRegExp(packageName));
            pairClassName = pairClassName.replaceAll("\\$\\{class\\}", this.escapeForRegExp(className));
            pairTestClassNameList.add(pairClassName);
            ++i;
        }
        return pairTestClassNameList;
    }

    private List<String> getPairClassNameList(IType target) {
        ArrayList<String> pairClassNameList = new ArrayList<String>();
        String packageName = target.getPackageFragment().getElementName();
        int i = 0;
        while (i < this.namingRules.size()) {
            String namingRule = this.namingRules.get(i);
            String testUnderClassName = this.getTestUnderClassName(target, namingRule);
            if (testUnderClassName != null) {
                String pairClassName = namingRule.replaceAll(packageName.length() == 0 ? "\\$\\{package\\}\\.?" : "\\$\\{package\\}", this.escapeForRegExp(packageName));
                if ((pairClassName = pairClassName.replaceAll("\\$\\{class\\}", this.escapeForRegExp(testUnderClassName))).equals(target.getFullyQualifiedName())) {
                    pairClassNameList.add(String.valueOf(packageName.length() == 0 ? "" : String.valueOf(packageName) + ".") + testUnderClassName);
                }
            }
            ++i;
        }
        return pairClassNameList;
    }

    private String getTestUnderClassName(IType target, String namingRule) {
        String testUnderClassName = null;
        String packageName = target.getPackageFragment().getElementName();
        namingRule = namingRule.replaceAll(packageName.length() == 0 ? "\\$\\{package\\}\\.?" : "\\$\\{package\\}", this.escapeForRegExp(packageName));
        Pattern p = Pattern.compile(this.escapeForRegExp(namingRule = namingRule.replaceAll("\\$\\{class\\}", "(\\\\w+)")));
        Matcher m = p.matcher(target.getFullyQualifiedName());
        if (m.matches()) {
            testUnderClassName = m.group(1);
        }
        return testUnderClassName;
    }

    protected boolean exists(String folder, IType type) {
        String[] testSrcFolderSegments = (String.valueOf(type.getJavaProject().getElementName()) + folder).split("\\/");
        if (testSrcFolderSegments.length != type.getAncestor(3).getPath().toFile().getPath().split("\\\\").length - 1) {
            return false;
        }
        int i = 0;
        while (i < testSrcFolderSegments.length) {
            if (!testSrcFolderSegments[i].equals(type.getPath().segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String escapeForRegExp(String value) {
        return value.replaceAll("\\$", "\\\\\\$").replaceAll("\\.", "\\\\\\.");
    }

    public IType getCreationClass(IType target) throws JavaModelException {
        boolean isTestClass = this.isTestClass(target);
        List<String> pairClassNameList = isTestClass ? this.getPairClassNameList(target) : this.getPairTestClassNameList(target);
        String pairClassName = pairClassNameList.get(0);
        IPackageFragmentRoot pkgFragmentRoot = target.getJavaProject().getPackageFragmentRoot(String.valueOf(target.getJavaProject().getPath().toOSString()) + (isTestClass ? this.javaSrcFolder : this.testSrcFolder));
        IPackageFragment pkgFragment = pkgFragmentRoot.getPackageFragment(this.getPackageName(pairClassName));
        ICompilationUnit creationClass = pkgFragment.getCompilationUnit(String.valueOf(this.getSimpleName(pairClassName)) + ".java");
        return creationClass.getType(this.getSimpleName(pairClassName));
    }

    private String getSimpleName(String className) {
        int index = className.lastIndexOf(46);
        return index < 0 ? className : className.substring(index + 1);
    }

    private String getPackageName(String className) {
        int index = className.lastIndexOf(46);
        return index < 0 ? "" : className.substring(0, index);
    }
}

