/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.filter;

import static org.junit.Assert.*;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * AppendTest.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/08/10
 * @since   JDK5.0 Tiger
 */
public class AppendTest {

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testInvoke() {
		Append target = new Append();
		String[] args = {"def"};
		String result = target.invoke("abc", args);
		assertEquals("abcdef", result);
	}

	@Test
	public void testInvoke2() {
		Append target = new Append();
		String[] args = {"def", "ghi"};
		String result = target.invoke("abc", args);
		assertEquals("abcdefghi", result);
	}

	@Test
	public void testInvoke3() {
		Append target = new Append();
		String[] args = {};
		String result = target.invoke("abc", args);
		assertEquals("abc", result);
	}

}
