/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx;

//import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * ELUtilsTest.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/09/13
 * @since   JDK5.0 Tiger
 */
public class ELUtilsTest {

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * {@link jp.sf.tatooine.gtx.ELUtils#parse(java.lang.String)} のためのテスト・メソッド。
	 */
//	@Test
	public void testParse() throws Exception {
		
	}

	/**
	 * {@link jp.sf.tatooine.gtx.ELUtils#evaluateEL(jp.sf.tatooine.gtx.GtxContext, java.lang.String)} のためのテスト・メソッド。
	 */
	@Test
	public void testEvaluateEL() {
//		fail("まだ実装されていません。");
	}
	
	@Test
	public void testEL() throws Exception {
	
		ArrayList<Object> list = new ArrayList<Object>();
		list.add("1");
		list.add("2");
		list.add("3");
		list.add("4");
		list.add(true);
//		System.out.println(list);
		
		HashMap<Object, Object> map = new HashMap<Object, Object>();
		map.put("aaa", "bbb");
		map.put("ccc", "ddd");
		map.put("eee", true);
		map.put("ggg", null);
		map.put("list", list);
//		System.out.println(map);
		
		String[] strAry = new String[] {"abc", "def", "ghi"};
		
		Map<String, Object> contextMap = new HashMap<String, Object>();
		contextMap.put("map", map);
		contextMap.put("list", list);
		contextMap.put("ary", strAry);
		
		JexlContext jexlContext = JexlHelper.createContext();
		
		Expression e1 = ExpressionFactory.createExpression("list");
		jexlContext.setVars(contextMap);
		Object o1 = e1.evaluate(jexlContext);
		System.out.println(o1.getClass());
		System.out.println(o1);

		Expression e2 = ExpressionFactory.createExpression("map");
		jexlContext.setVars(contextMap);
		Object o2 = e2.evaluate(jexlContext);
		System.out.println(o2.getClass());
		System.out.println(o2);

		
		Expression e3 = ExpressionFactory.createExpression("ary");
		jexlContext.setVars(contextMap);
		Object o3 = e3.evaluate(jexlContext);
		System.out.println(o3.getClass());
		System.out.println(o3.getClass().isArray());
		System.out.println(Arrays.asList(o3));
		
	}

}
