package jp.sf.tatooine.gtx.filter;

import static org.junit.Assert.*;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TruncateTest {

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testInvoke() {
		
		Truncate target = new Truncate();
		
		String result = null;
		String[] args = new String[] {"10"};
		result = target.invoke("abc def ghi jkl mno pqr", args);
		assertEquals("abc def", result);
		
		args = new String[] {"10", "...", "true"};
		result = target.invoke("abc def ghi jkl mno pqr", args);
		assertEquals("abc def gh...", result);
		
		result = target.invoke("abc def gh", args);
		assertEquals("abc def gh", result);
		
		result = target.invoke("abc def g", args);
		assertEquals("abc def g", result);
		
		args = new String[] {"10", "...", "false"};
		result = target.invoke("abc def ghi", args);
		assertEquals("abc def...", result);
		
		try {
			args = new String[] {};
			result = target.invoke("123456789", args);
			fail();
		}
		catch (IllegalArgumentException e) { }
		
		try {
			args = new String[] {"10", "...", "fff"};
			result = target.invoke("123456789", args);
			fail();
		}
		catch (IllegalArgumentException e) { }
		
		try {
			args = new String[] {"10", "...", "true", ""};
			result = target.invoke("123456789", args);
			fail();
		}
		catch (IllegalArgumentException e) { }
	}

}
