/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.tatooine.gtx.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.tatooine.gtx.GtxContext;
import jp.sf.tatooine.gtx.GtxSyntaxException;
import jp.sf.tatooine.gtx.LoopRange;
import jp.sf.tatooine.gtx.Tag;
import jp.sf.tatooine.gtx.node.Attribute;
import jp.sf.tatooine.gtx.node.ELUtils;
import jp.sf.tatooine.gtx.node.GtxAttribute;
import jp.sf.tatooine.gtx.node.GtxAttributeType;
import jp.sf.tatooine.gtx.node.GtxFor;
import jp.sf.tatooine.gtx.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementNode
extends Node {
    private String _name;
    private List<Node> _childNodes = new ArrayList<Node>();
    private List<Attribute> _attrs = new ArrayList<Attribute>();
    private Map<GtxAttributeType, GtxAttribute> _gtxAttrs = new HashMap<GtxAttributeType, GtxAttribute>();

    public ElementNode(String name) {
        this._name = name;
    }

    public void addGtxAttribute(GtxAttribute attr) {
        this._gtxAttrs.put(attr.getType(), attr);
        this._attrs.add(attr);
    }

    public String getName() {
        return this._name;
    }

    public void addAttribute(Attribute attr) {
        this._attrs.add(attr);
    }

    public void appendChild(Node node) {
        node.setParent(this);
        this._childNodes.add(node);
    }

    public List<Node> getChildNodes() {
        return this._childNodes;
    }

    @Override
    public void evaluate(StringBuilder builder, GtxContext context) throws GtxSyntaxException {
        GtxAttribute gtxAttr = null;
        String value = null;
        boolean ignore = false;
        if (this._gtxAttrs.containsKey((Object)GtxAttributeType.IGNORE)) {
            gtxAttr = this._gtxAttrs.get((Object)GtxAttributeType.IGNORE);
            value = gtxAttr.getValue();
            if (!value.matches("true|false")) {
                throw new GtxSyntaxException(String.format("ignore=%s : ignore\u306b\u306fboolean\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002", value));
            }
            ignore = Boolean.valueOf(ELUtils.evaluateEL(context, value));
        }
        if (!ignore && this._gtxAttrs.containsKey((Object)GtxAttributeType.IF)) {
            gtxAttr = this._gtxAttrs.get((Object)GtxAttributeType.IF);
            value = gtxAttr.getValue();
            if (!value.matches("true|false")) {
                throw new GtxSyntaxException(String.format("if=%s : if\u306b\u306fboolean\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002", value));
            }
            boolean bif = Boolean.valueOf(ELUtils.evaluateEL(context, value));
            if (!bif) {
                return;
            }
        }
        if (!ignore && this._gtxAttrs.containsKey((Object)GtxAttributeType.UNLESS)) {
            gtxAttr = this._gtxAttrs.get((Object)GtxAttributeType.UNLESS);
            value = gtxAttr.getValue();
            if (!value.matches("true|false")) {
                throw new GtxSyntaxException(String.format("unless=%s : unless\u306b\u306fboolean\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002", value));
            }
            boolean unless = Boolean.valueOf(ELUtils.evaluateEL(context, value));
            if (unless) {
                return;
            }
        }
        LoopRange range = new LoopRange(1, 1);
        int step = 1;
        String index = null;
        boolean inside = false;
        GtxContext localContext = new GtxContext();
        localContext.setParent(context);
        if (!ignore && this._gtxAttrs.containsKey((Object)GtxAttributeType.FOR)) {
            GtxFor gtxFor = (GtxFor)this._gtxAttrs.get((Object)GtxAttributeType.FOR);
            value = gtxFor.getValue();
            range = LoopRange.parse(ELUtils.evaluateEL(localContext, value));
            step = Integer.valueOf(ELUtils.evaluateEL(localContext, gtxFor.getStep()));
            index = gtxFor.getIndex();
            if (index != null) {
                index = ELUtils.evaluateEL(localContext, index);
            }
            if (!(value = gtxFor.getInside()).matches("true|false")) {
                throw new GtxSyntaxException(String.format("inside=%s : inside\u306b\u306fboolean\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002", value));
            }
            inside = Boolean.valueOf(ELUtils.evaluateEL(localContext, value));
        }
        if (inside) {
            builder.append("<");
            builder.append(this._name);
            for (Attribute attr : this._attrs) {
                if (attr.getType() != GtxAttributeType.NA) continue;
                builder.append(" ");
                attr.evaluate(builder, localContext);
                if (!attr.getName().equalsIgnoreCase("id")) continue;
                this.evaluateTag(ELUtils.evaluateEL(context, attr.getValue()), builder, localContext);
            }
            if (!ignore && this._gtxAttrs.containsKey((Object)GtxAttributeType.INNER_TEXT)) {
                gtxAttr = this._gtxAttrs.get((Object)GtxAttributeType.INNER_TEXT);
                value = gtxAttr.getValue();
                builder.append(">");
                int i = range.getBegin();
                while (i <= range.getEnd()) {
                    if (index != null) {
                        localContext.put(index, i);
                    }
                    builder.append(ELUtils.evaluateEL(localContext, value));
                    i += step;
                }
                builder.append("</");
                builder.append(this._name);
                builder.append(">");
            } else if (this._childNodes.isEmpty()) {
                builder.append(" />");
            } else {
                builder.append(">");
                int i = range.getBegin();
                while (i <= range.getEnd()) {
                    if (index != null) {
                        localContext.put(index, i);
                    }
                    for (Node node : this._childNodes) {
                        node.evaluate(builder, localContext);
                    }
                    i += step;
                }
                builder.append("</");
                builder.append(this._name);
                builder.append(">");
            }
        } else {
            int i = range.getBegin();
            while (i <= range.getEnd()) {
                if (index != null) {
                    localContext.put(index, i);
                }
                builder.append("<");
                builder.append(this._name);
                for (Attribute attr : this._attrs) {
                    if (attr.getType() != GtxAttributeType.NA) continue;
                    builder.append(" ");
                    attr.evaluate(builder, localContext);
                    if (!attr.getName().equalsIgnoreCase("id")) continue;
                    this.evaluateTag(ELUtils.evaluateEL(context, attr.getValue()), builder, localContext);
                }
                if (!ignore && this._gtxAttrs.containsKey((Object)GtxAttributeType.INNER_TEXT)) {
                    gtxAttr = this._gtxAttrs.get((Object)GtxAttributeType.INNER_TEXT);
                    value = gtxAttr.getValue();
                    builder.append(">");
                    builder.append(ELUtils.evaluateEL(localContext, value));
                    builder.append("</");
                    builder.append(this._name);
                    builder.append(">");
                } else if (this._childNodes.isEmpty()) {
                    builder.append(" />");
                } else {
                    builder.append(">");
                    for (Node node : this._childNodes) {
                        node.evaluate(builder, localContext);
                    }
                    builder.append("</");
                    builder.append(this._name);
                    builder.append(">");
                }
                i += step;
            }
        }
        if (!ignore && this._gtxAttrs.containsKey((Object)GtxAttributeType.NULL)) {
            gtxAttr = this._gtxAttrs.get((Object)GtxAttributeType.NULL);
            value = gtxAttr.getValue();
            ELUtils.evaluateEL(context, value);
        }
    }

    private void evaluateTag(String id, StringBuilder builder, GtxContext context) throws GtxSyntaxException {
        Tag tag = context.getTag(id);
        if (tag != null) {
            String tagName = tag.getTagName();
            if (tagName != null && !this._name.equalsIgnoreCase(tagName)) {
                throw new IllegalArgumentException(String.format("id(%s)\u306e\u6574\u5408\u6027\u304c\u53d6\u308c\u3066\u3044\u307e\u305b\u3093\uff1a%s", this._name, tagName));
            }
            Map<String, String> attrMap = tag.getRawMap();
            for (Map.Entry<String, String> entry : attrMap.entrySet()) {
                Attribute attr = new Attribute(GtxAttributeType.NA, entry.getKey(), entry.getValue());
                builder.append(" ");
                attr.evaluate(builder, context);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(this._name);
        for (Attribute attr : this._attrs) {
            builder.append(" ");
            builder.append(attr.toString());
        }
        if (this._childNodes.isEmpty()) {
            builder.append(" />");
        } else {
            builder.append(">");
            for (Node node : this._childNodes) {
                builder.append(node.toString());
            }
            builder.append("</");
            builder.append(this._name);
            builder.append(">");
        }
        return builder.toString();
    }
}

