/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx.filter;

import static org.junit.Assert.*;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * LpadTest.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/04/18
 * @since   JDK5.0 Tiger
 */
public class LpadTest {

	@Before
	public void setUp() throws Exception {
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testInvokeN1() {
		Lpad target = new Lpad();
		String[] args = {"10", "0"};
		String result = target.invoke("123", args);
		assertEquals("0000000123", result);
	}

	@Test
	public void testInvokeN3() {
		Lpad target = new Lpad();
		String[] args = {"10", "ab"};
		String result = target.invoke("123", args);
		assertEquals("abababa123", result);
	}

	@Test
	public void testInvokeN2() {
		Lpad target = new Lpad();
		String[] args = {"10"};
		String result = target.invoke("123", args);
		assertEquals("       123", result);
	}

	@Test
	public void testInvoke2() {
		Lpad target = new Lpad();
		String[] args = {};
		try {
			String result = target.invoke("123", args);
			fail(result);
		}
		catch (Exception e) { }
	}

	@Test
	public void testInvoke3() {
		Lpad target = new Lpad();
		String[] args = {"aaa", "bbb"};
		try {
			String result = target.invoke("123", args);
			fail(result);
		}
		catch (Exception e) { }
	}

	@Test
	public void testInvoke4() {
		Lpad target = new Lpad();
		String[] args = {"-10", "bbb"};
		try {
			String result = target.invoke("123", args);
			fail(result);
		}
		catch (Exception e) { }
	}

	@Test
	public void testInvoke5() {
		Lpad target = new Lpad();
		String[] args = {"10", "bbb", "ccc"};
		try {
			String result = target.invoke("123", args);
			fail(result);
		}
		catch (Exception e) { }
	}
	
}
