/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.tatooine.base.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class NameUtils {
    private static final Pattern PTN_UNDERSCORE1 = Pattern.compile("([A-Z][^A-Z]+)");
    private static final Pattern PTN_UNDERSCORE2 = Pattern.compile("([A-Z][A-Z]+)");
    private static final Pattern PTN_CLASSIFY = Pattern.compile("(_[^_]*)");

    private NameUtils() {
    }

    public static String underscore(String name) {
        StringBuffer buf = new StringBuffer();
        String from = StringUtils.capitalize((String)name);
        Matcher m1 = PTN_UNDERSCORE1.matcher(from);
        while (m1.find()) {
            String s = m1.group();
            m1.appendReplacement(buf, "_" + s);
        }
        m1.appendTail(buf);
        Matcher m2 = PTN_UNDERSCORE2.matcher(buf.toString());
        buf = new StringBuffer();
        while (m2.find()) {
            String s = m2.group();
            m2.appendReplacement(buf, "_" + StringUtils.capitalize((String)s));
        }
        m2.appendTail(buf);
        String result = StringUtils.lowerCase((String)buf.toString());
        if (result.startsWith("_")) {
            result = result.substring(1);
        }
        result = result.replaceAll("__", "_");
        return result;
    }

    public static String classify(String name) {
        StringBuffer buf = new StringBuffer();
        String from = StringUtils.capitalize((String)name);
        Matcher m = PTN_CLASSIFY.matcher(from);
        while (m.find()) {
            String s = m.group();
            m.appendReplacement(buf, StringUtils.capitalize((String)s.substring(1)));
        }
        m.appendTail(buf);
        return buf.toString();
    }
}

