/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx;

/**
 * Filter.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/04/17
 * @since   JDK5.0 Tiger
 */
public interface Filter {

	/**
	 * フィルタ処理を実行する.
	 * <p>
	 * フィルタは次の書式で指定します。
	 * <code>${el:filter1:filter2(arg):filter3(arg1, arg2)}</code>
	 * 
	 * @param value	直前のELまたはFilterの処理結果文字列
	 * @param arg		引数リスト
	 * @return	処理結果文字列
	 */
	String invoke(String value, String[] args);
}
