package jp.sourceforge.talisman.hermes;

/*
 * $Id: HermesContextExporterTest.java 198 2009-05-30 14:45:26Z tama3 $
 */

import java.io.StringWriter;

import org.junit.Assert;
import org.junit.Test;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 198 $
 */
public class HermesContextExporterTest{
    private static String ln = System.getProperty("line.separator");
    private String hermesXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + ln +
        "<hermes>" + ln +
        "  <repository-scope>BOTH</repository-scope>" + ln +
        "  <dependency-scope>COMPILE, RUNTIME</dependency-scope>" + ln +
        "  <updating-policy>DESTINATION_CHECK</updating-policy>" + ln +
        "  <repositories>" + ln +
        "    <repository>" + ln +
        "      <id>central</id>" + ln +
        "      <name>Maven2 Central Repository</name>" + ln +
        "      <url>http://repo1.maven.org/maven2/</url>" + ln +
        "    </repository>" + ln +
        "    <repository>" + ln +
        "      <id>talisman.sourceforge.jp</id>" + ln +
        "      <name>Talisman Maven Repository</name>" + ln +
        "      <url>http://talisman.sourceforge.jp/maven2/</url>" + ln +
        "    </repository>" + ln +
        "    <repository>" + ln +
        "      <id>stigmata.sourceforge.jp</id>" + ln +
        "      <name>Stigmata Maven Repository</name>" + ln +
        "      <url>http://stigmata.sourceforge.jp/maven2/</url>" + ln +
        "    </repository>" + ln +
        "  </repositories>" + ln +
        "  <dependencies>" + ln +
        "    <dependency>" + ln +
        "      <groupId>jp.sourceforge</groupId>" + ln +
        "      <artifactId>stigmata</artifactId>" + ln +
        "      <version>2.0.0</version>" + ln +
        "      <scope>COMPILE</scope>" + ln +
        "    </dependency>" + ln +
        "  </dependencies>" + ln +
        "</hermes>" + ln;

    private String hermes2Xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + ln + 
        "<hermes>" + ln +
        "  <repository-scope>BOTH</repository-scope>" + ln +
        "  <dependency-scope>COMPILE, RUNTIME</dependency-scope>" + ln +
        "  <updating-policy>DESTINATION_CHECK</updating-policy>" + ln +
        "  <repositories>" + ln +
        "    <repository>" + ln +
        "      <id>central</id>" + ln +
        "      <name>Maven2 Central Repository</name>" + ln +
        "      <url>http://repo1.maven.org/maven2/</url>" + ln +
        "    </repository>" + ln +
        "    <repository>" + ln +
        "      <id>talisman.sourceforge.jp</id>" + ln +
        "      <name>Talisman Maven Repository</name>" + ln +
        "      <url>http://talisman.sourceforge.jp/maven2/</url>" + ln +
        "    </repository>" + ln +
        "    <repository>" + ln +
        "      <id>stigmata.sourceforge.jp</id>" + ln +
        "      <name>Stigmata Maven Repository</name>" + ln +
        "      <url>http://stigmata.sourceforge.jp/maven2/</url>" + ln +
        "    </repository>" + ln +
        "  </repositories>" + ln +
        "  <dependencies>" + ln +
        "    <dependency>" + ln +
        "      <groupId>junit</groupId>" + ln +
        "      <artifactId>junit</artifactId>" + ln +
        "      <version>4.3</version>" + ln +
        "      <scope>TEST</scope>" + ln +
        "    </dependency>" + ln +
        "  </dependencies>" + ln +
        "  <ignores>" + ln +
        "    <ignore>" + ln +
        "      <groupId>commons-beanutils</groupId>" + ln +
        "      <artifactId>commons-beanutils</artifactId>" + ln +
        "    </ignore>" + ln +
        "  </ignores>" + ln +
        "</hermes>" + ln;

    @Test
    public void testBasic() throws Exception{
        HermesContextParser parser = new HermesContextParser();
        HermesContext context = parser.parse(getClass().getResource("/hermes/hermes.xml"));

        StringWriter out = new StringWriter();
        HermesContextExporter exporter = new HermesContextExporter();
        exporter.export(out, context);
        Assert.assertEquals(out.toString(), hermesXml);
        out.close();
    }

    @Test
    public void testBasic2() throws Exception{
        HermesContextParser parser = new HermesContextParser();
        HermesContext context = parser.parse(getClass().getResource("/hermes/hermes2.xml"));

        StringWriter out = new StringWriter();
        HermesContextExporter exporter = new HermesContextExporter();
        exporter.export(out, context);
        Assert.assertEquals(out.toString(), hermes2Xml);
        out.close();
    }
}