package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: DependencyPanel.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.DependencyScope;

/**
 * 
 * @author Harauki Tamada
 * @version $Revision: 187 $
 */
class DependencyPanel extends JPanel{
    private static final long serialVersionUID = -3719046752834178339L;

    private JTextField groupIdField;
    private JTextField artifactIdField;
    private JTextField versionField;
    private JComboBox dependencyScopeCombo;
    private boolean versionFlag;

    public DependencyPanel(){
        this(true);
    }

    public DependencyPanel(boolean versionFlag){
        this("", "", "", DependencyScope.COMPILE, versionFlag);
    }

    public DependencyPanel(Artifact artifact){
        this(artifact, true);
    }
    
    public DependencyPanel(Artifact artifact, boolean versionFlag){
        this(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), versionFlag);
    }

    public DependencyPanel(String groupId, String artifactId, String version, DependencyScope scope){
        this(groupId, artifactId, version, scope, true);
    }

    public DependencyPanel(String groupId, String artifactId, String version, DependencyScope scope, boolean versionFlag){
        groupIdField = new JTextField(groupId);
        artifactIdField = new JTextField(artifactId);
        versionField = new JTextField(version == null? "": version);
        dependencyScopeCombo = new JComboBox();
        for(DependencyScope s: DependencyScope.values()){
            dependencyScopeCombo.addItem(s.name());
        }
        dependencyScopeCombo.setSelectedItem(scope.name());
        this.versionFlag = versionFlag;

        initLayout();
    }

    public Artifact getDependency(){
        String groupId = groupIdField.getText().trim();
        String artifactId = artifactIdField.getText().trim();
        String version = versionField.getText().trim();
        if(groupId.equals("") || artifactId.equals("")){
            throw new IllegalArgumentException(String.format(
                "Data is missing [groupId: %s], [artifactId: %s], [version: %s]", groupId, artifactId, version
            ));
        }
        if(versionFlag && version.equals("")){
            throw new IllegalArgumentException(String.format(
                "Data is missing [groupId: %s], [artifactId: %s], [version: %s]", groupId, artifactId, version
            ));
        }

        if(versionFlag){
            return new Artifact(
                groupId, artifactId, version,
                DependencyScope.valueOf((String)dependencyScopeCombo.getSelectedItem())
            );
        }
        return new Artifact(groupId, artifactId);
    }

    private void initLayout(){
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();

        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.weightx = 0d;

        add(new JLabel("Group Id"), gbc);
        gbc.gridy = 1;
        add(new JLabel("Artifact Id"), gbc);

        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 1d;

        add(groupIdField, gbc);
        gbc.gridy = 1;
        add(artifactIdField, gbc);

        if(versionFlag){
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.fill = GridBagConstraints.NONE;
            gbc.weightx = 0d;

            add(new JLabel("Version"), gbc);
            gbc.gridy = 3;
            add(new JLabel("Scope"), gbc);

            gbc.fill = GridBagConstraints.HORIZONTAL;
            gbc.weightx = 1d;
            gbc.gridy = 2;
            gbc.gridx = 1;
            add(versionField, gbc);
            gbc.gridy = 3;
            add(dependencyScopeCombo, gbc);
        }
    }
}
