package jp.sourceforge.talisman.hermes.maven;

/*
 * $Id: RepositoryManager.java 203 2009-06-01 05:44:11Z tama3 $
 */

import java.io.IOException;

import jp.sourceforge.talisman.hermes.HermesContext;

/**
 * Manager class for repositories.
 * 
 * @author Haruaki Tamada
 * @version $Revision: 203 $
 */
public class RepositoryManager{
    private HermesContext context;

    /**
     * Basic constructor.
     */
    public RepositoryManager(HermesContext context){
        this.context = context;
    }

    /**
     * returns context.
     */
    public HermesContext getContext(){
        return context;
    }

    /**
     * {@link #findArtifact(Artifact) <code>findArtifact(new Artifact(groupId, artifactId))</code>}.
     */
    public Artifact findArtifact(String groupId, String artifactId) throws IOException{
        return findArtifact(groupId, artifactId, null);
    }

    /**
     * {@link #findArtifact(Artifact) <code>findArtifact(new Artifact(groupId, artifactId, version))</code>}.
     */
    public Artifact findArtifact(String groupId, String artifactId, String version) throws IOException{
        return findArtifact(new Artifact(groupId, artifactId, version));
    }

    /**
     * find given artifact in scoped repositories.
     * 
     * @param artifact finding target.
     * @return found artifact. If this repository do not have given artifact, this method returns null.
     * @throws IOException I/O error while finding artifact from repositories.
     * @see Repository#findArtifact(Artifact)
     * @see HermesContext#getScopedRepositories
     */
    public Artifact findArtifact(Artifact artifact) throws IOException{
        if(artifact.hasVersion() && artifact.getPom().isAlreadyRead()){
            return artifact;
        }
        for(Repository repo: getContext().getScopedRepositories()){
            if(repo.contains(artifact)){
                try{
                    Artifact foundArtifact = repo.findArtifact(artifact);
                    if(foundArtifact != null){
                        return foundArtifact;
                    }
                } catch(RepositoryItemNotFoundException e){
                    // ignore exception
                }
            }
        }
        return null;
    }
}
