package jp.sourceforge.talisman.hermes.maven;

/*
 * $Id: RepositoryItem.java 198 2009-05-30 14:45:26Z tama3 $
 */

import jp.sourceforge.talisman.hermes.ResourceType;

/**
 * This interface is represents an item in Maven2 repository.
 * 
 * @author Haruaki Tamada
 * @version $Revision: 198 $
 */
public interface RepositoryItem{
    /**
     * returns artifactId of this item.
     */
    public String getArtifactId();

    /**
     * returns groupId of this item.
     */
    public String getGroupId();

    /**
     * returns type of this item.
     */
    public ResourceType getType();

    /**
     * returns relative path of this item from root of repository.
     */
    public String getRelativePath();

    /**
     * returns file name of this item.
     */
    public String getFileName();
}
