package jp.sourceforge.talisman.hermes;

/*
 * $Id: Version.java 198 2009-05-30 14:45:26Z tama3 $
 */

import java.io.Serializable;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 198 $
 */
public class Version implements Serializable, Comparable<Version>{
    private static final long serialVersionUID = 7980518164461500648L;

    private String[] strings;
    private String original;
    private String separator;

    public Version(String versionString){
        this(versionString, "[-.]");
    }

    public Version(String versionString, String separateRegex){
        original = versionString;
        strings = versionString.split(separateRegex);
        this.separator = separateRegex;
    }

    public boolean isSnapshot(){
        return original.toLowerCase().endsWith("snapshot");
    }

    public String toString(){
        return original;
    }

    public int hashCode(){
        return original.hashCode() | separator.hashCode();
    }

    public boolean equals(Object o){
        return o instanceof Version && compareTo((Version)o) == 0;
    }

    /**
     * v1 = 1.1.0, v2 = 1.2.0.
     * v1.compareTo(v2): negative integer
     * v1.compareTo(v1): 0
     * v2.compareTo(v1): positive integer
     */
    public int compareTo(Version version){
        int v = 0;
        String[] s1 = copyStringArray(strings);
        String[] s2 = copyStringArray(version.strings);
        int index = 0;

        for(int i = 0; i < s1.length && i < s2.length; i++){
            if(!s1[i].equals(s2[i])){
                try{
                    int i1 = Integer.parseInt(s1[i]);
                    int i2 = Integer.parseInt(s2[i]);
                    if(i1 < i2){
                        v = -1;
                    }
                    else{
                        v = 1;
                    }
                } catch(NumberFormatException e){
                    if(s1[i].compareTo(s2[i]) < 0){
                        v = -1;
                    }
                    else{
                        v = 1;
                    }
                }
                break;
            }
            else{
                index++;
            }
        }
        if(v == 0 && (index != s1.length || index != s2.length)){
            if(s1.length < s2.length){
                v = -1;
            }
            else{
                v = 1;
            }
        }
        return v;
    }

    private String[] copyStringArray(String[] values){
        String[] strings = new String[values.length];
        for(int i = 0; i < strings.length; i++){
            strings[i] = values[i].toLowerCase();
            if(strings[i].equals("alpha"))         strings[i] = "1a";
            else if(strings[i].equals("beta"))     strings[i] = "1b";
            else if(strings[i].equals("gamma"))    strings[i] = "1c";
            else if(strings[i].equals("delta"))    strings[i] = "1d";
            else if(strings[i].equals("epsilon"))  strings[i] = "1e";
            else if(strings[i].equals("zeta"))     strings[i] = "1f";
            else if(strings[i].equals("eta"))      strings[i] = "1g";
            else if(strings[i].equals("theta"))    strings[i] = "1h";
            else if(strings[i].equals("iota"))     strings[i] = "1i";
            else if(strings[i].equals("kappa"))    strings[i] = "1j";
            else if(strings[i].equals("lambda"))   strings[i] = "1k";
            else if(strings[i].equals("mu"))       strings[i] = "1l";
            else if(strings[i].equals("nu"))       strings[i] = "1m";
            else if(strings[i].equals("xi"))       strings[i] = "1n";
            else if(strings[i].equals("o"))        strings[i] = "1o";
            else if(strings[i].equals("pi"))       strings[i] = "1p";
            else if(strings[i].equals("rho"))      strings[i] = "1q";
            else if(strings[i].equals("sigma"))    strings[i] = "1r";
            else if(strings[i].equals("tau"))      strings[i] = "1s";
            else if(strings[i].equals("upsilon"))  strings[i] = "1t";
            else if(strings[i].equals("phi"))      strings[i] = "1u";
            else if(strings[i].equals("chi"))      strings[i] = "1v";
            else if(strings[i].equals("psi"))      strings[i] = "1w";
            else if(strings[i].equals("omega"))    strings[i] = "1x";
            else if(strings[i].equals("snapshot")) strings[i] = "0a";
            else if(strings[i].startsWith("rc"))   strings[i] = "2" + strings[i].substring(2);
        }
        return strings;
    }
}
