package jp.sourceforge.talisman.hermes;

/*
 * $Id: RepositoryScope.java 198 2009-05-30 14:45:26Z tama3 $
 */

import java.net.URL;

/**
 * This enum represents searching target repository.
 * 
 * @author Haruaki Tamada
 * @version $Revision: 198 $
 */
public enum RepositoryScope{
    /**
     * Using this scope, hermes only use local repository.
     */
    LOCAL_ONLY{
        public boolean isScope(URL url){
            return url.getProtocol().equals("file");
        }
    },
    /**
     * Using this scope, hermes only use remote repository.
     */
    REMOTE_ONLY{
        public boolean isScope(URL url){
            return !LOCAL_ONLY.isScope(url);
        }
    },
    /**
     * Using this scope, hermes use local repository and remote
     * repository.
     */
    BOTH{
        public boolean isScope(URL url){
            return true;
        }
    };

    /**
     * If given url is allowable as target, this method returns true.
     */
    public abstract boolean isScope(URL url);
}
