package jp.sourceforge.talisman.hermes;

/*
 * $Id: DelegateHermesPercentageListener.java 192 2009-05-29 07:07:46Z tama3 $
 */

import java.util.HashMap;
import java.util.Map;

import jp.sourceforge.talisman.hermes.maven.Artifact;

/**
 *
 * @author Haruaki Tamada
 * @version $Revision: 192 $
 */
class DelegateHermesPercentageListener implements HermesListener{
    private HermesPercentageListener listener;
    private Map<Artifact, Integer> fileSizes = new HashMap<Artifact, Integer>();

    public DelegateHermesPercentageListener(HermesPercentageListener listener){
        this.listener = listener;
    }

    public void fileSizeUpdated(HermesEvent e){
        listener.progress(e, (double)e.getSize() / fileSizes.get(e.getArtifact()));
    }

    public void finish(HermesEvent e){
        listener.finish(e);
    }

    public void fileSizeGotten(HermesEvent e){
        fileSizes.put(e.getArtifact(), e.getSize());
        listener.fileSizeGotten(e);
    }

    public void targetResolved(HermesEvent e){
        listener.targetResolved(e);
    }

    public void downloadDone(HermesEvent e){
        listener.downloadDone(e);
    }

    public HermesPercentageListener getListener(){
        return listener;
    }
}
