package jp.sourceforge.talisman.hermes.maven;

/*
 * $Id: ProjectObjectModelParserTest.java 174 2009-05-18 02:42:13Z tama3 $
 */

import java.util.Iterator;

import jp.sourceforge.talisman.hermes.ResourceType;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.DependencyScope;
import jp.sourceforge.talisman.hermes.maven.ProjectObjectModel;
import jp.sourceforge.talisman.hermes.maven.ProjectObjectModelParser;
import jp.sourceforge.talisman.hermes.maven.RepositoryItemMismatchException;

import org.junit.Assert;
import org.junit.Test;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 174 $
 */
public class ProjectObjectModelParserTest{
    @Test
    public void testBasic() throws Exception{
        Artifact artifact = new Artifact("jp.sourceforge", "stigmata", "2.0.0");
        ProjectObjectModel model = artifact.getPom();
        ProjectObjectModelParser parser = new ProjectObjectModelParser(model);
        parser.parse(getClass().getResourceAsStream("/repository/jp/sourceforge/stigmata/2.0.0/stigmata-2.0.0.pom"));

        Assert.assertEquals(model.getRelativePath(), "jp/sourceforge/stigmata/2.0.0");
        Assert.assertEquals(model.getFileName(), "stigmata-2.0.0.pom");
        Assert.assertEquals(model.getType(), ResourceType.POM);
        Assert.assertEquals(model.getArtifactId(), "stigmata");
        Assert.assertEquals(model.getGroupId(), "jp.sourceforge");
        Assert.assertEquals(model.getVersion(), "2.0.0");
        Assert.assertEquals(model.getDependencyCount(), 8);
        Assert.assertEquals(model.getLicenseCount(), 1);

        Iterator<Artifact> iterator = model.iterator();
        Artifact a1 = iterator.next();
        Assert.assertEquals(a1.getGroupId(), "asm");
        Assert.assertEquals(a1.getArtifactId(), "asm-all");
        Assert.assertEquals(a1.getVersion(), "3.1");
        Assert.assertEquals(a1.getScope(), DependencyScope.COMPILE);

        Artifact a2 = iterator.next();
        Assert.assertEquals(a2.getGroupId(), "commons-dbutils");
        Assert.assertEquals(a2.getArtifactId(), "commons-dbutils");
        Assert.assertEquals(a2.getVersion(), "1.1");
        Assert.assertEquals(a2.getScope(), DependencyScope.COMPILE);

        Artifact a3 = iterator.next();
        Assert.assertEquals(a3.getGroupId(), "commons-beanutils");
        Assert.assertEquals(a3.getArtifactId(), "commons-beanutils");
        Assert.assertEquals(a3.getVersion(), "1.7.0");
        Assert.assertEquals(a3.getScope(), DependencyScope.COMPILE);

        Artifact a4 = iterator.next();
        Assert.assertEquals(a4.getGroupId(), "jp.sourceforge.talisman");
        Assert.assertEquals(a4.getArtifactId(), "mds");
        Assert.assertEquals(a4.getVersion(), "1.0.0");
        Assert.assertEquals(a4.getScope(), DependencyScope.COMPILE);

        Artifact a5 = iterator.next();
        Assert.assertEquals(a5.getGroupId(), "jp.sourceforge.talisman");
        Assert.assertEquals(a5.getArtifactId(), "xmlcli");
        Assert.assertEquals(a5.getVersion(), "1.2.2");
        Assert.assertEquals(a5.getScope(), DependencyScope.COMPILE);

        Artifact a6 = iterator.next();
        Assert.assertEquals(a6.getGroupId(), "jp.sourceforge.talisman");
        Assert.assertEquals(a6.getArtifactId(), "i18n");
        Assert.assertEquals(a6.getVersion(), "1.0.1");
        Assert.assertEquals(a6.getScope(), DependencyScope.COMPILE);

        Artifact a7 = iterator.next();
        Assert.assertEquals(a7.getGroupId(), "jp.sourceforge.stigmata");
        Assert.assertEquals(a7.getArtifactId(), "digger");
        Assert.assertEquals(a7.getVersion(), "1.1.0");
        Assert.assertEquals(a7.getScope(), DependencyScope.COMPILE);

        Artifact a8 = iterator.next();
        Assert.assertEquals(a8.getGroupId(), "junit");
        Assert.assertEquals(a8.getArtifactId(), "junit");
        Assert.assertEquals(a8.getVersion(), "4.3");
        Assert.assertEquals(a8.getScope(), DependencyScope.TEST);

        License[] licenses = model.getLicenses();
        Assert.assertEquals(licenses[0].getName(), "Apache License 2.0");
        Assert.assertEquals(licenses[0].getUrl(), "http://www.apache.org/licenses/LICENSE-2.0.txt");
    }

    @Test(expected=RepositoryItemMismatchException.class)
    public void testMismatchArtifact() throws Exception{
        Artifact artifact = new Artifact("jp.sourceforge", "NOTstigmata", "2.0.0");
        ProjectObjectModel model = artifact.getPom();
        ProjectObjectModelParser parser = new ProjectObjectModelParser(model);
        parser.parse(getClass().getResourceAsStream("/repository/jp/sourceforge/stigmata/2.0.0/stigmata-2.0.0.pom"));
    }

    @Test(expected=RepositoryItemMismatchException.class)
    public void testMismatchGroupId() throws Exception{
        Artifact artifact = new Artifact("NOTjp.sourceforge", "stigmata", "2.0.0");
        ProjectObjectModel model = artifact.getPom();
        ProjectObjectModelParser parser = new ProjectObjectModelParser(model);
        parser.parse(getClass().getResourceAsStream("/repository/jp/sourceforge/stigmata/2.0.0/stigmata-2.0.0.pom"));
    }

    @Test(expected=RepositoryItemMismatchException.class)
    public void testMismatchVersion() throws Exception{
        Artifact artifact = new Artifact("jp.sourceforge", "stigmata", "1.0.0");
        ProjectObjectModel model = artifact.getPom();
        ProjectObjectModelParser parser = new ProjectObjectModelParser(model);
        parser.parse(getClass().getResourceAsStream("/repository/jp/sourceforge/stigmata/2.0.0/stigmata-2.0.0.pom"));
    }
}
