package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: EditDependencyAction.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

import jp.sourceforge.talisman.hermes.maven.Artifact;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 187 $
 */
class EditDependencyAction extends RemoveDependencyAction{
    private static final long serialVersionUID = 7288606247559385783L;

    public EditDependencyAction(HermesContextBuilder parent, ListSelectionModel model, boolean versionFlag){
        super("Edit", parent, model, versionFlag);
    }

    public EditDependencyAction(HermesContextBuilder parent, ListSelectionModel model){
        this(parent, model, true);
    }

    public void actionPerformed(ActionEvent e){
        Artifact artifact = getDependency();
        if(artifact != null){
            DependencyPanel panel = new DependencyPanel(artifact, isIncludeVersion());
            int value = JOptionPane.showConfirmDialog(
                getParent(), panel, "Edit dependency",
                JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE
            );
            if(value == JOptionPane.OK_OPTION){
                Artifact artifact2 = panel.getDependency();
                if(!artifact.equals(artifact2)){
                    getContext().removeDependency(artifact);
                    getContext().addDependency(artifact2);
                }
            }
        }
    }
}
