package jp.sourceforge.talisman.hermes.ui.swing;

/*
 * $Id: AddRepositoryAction.java 187 2009-05-27 10:09:01Z tama3 $
 */

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 187 $
 */
class AddRepositoryAction extends AbstractAction{
    private static final long serialVersionUID = -1083920825219160889L;

    private HermesContextBuilder parent;

    public AddRepositoryAction(HermesContextBuilder parent){
        super("Add");
        this.parent = parent;
    }

    public void actionPerformed(ActionEvent e){
        RepositoryPanel panel = new RepositoryPanel();

        int value = JOptionPane.showConfirmDialog(parent, panel, "Add new repository", JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE);
        if(value == JOptionPane.OK_OPTION){
            try{
                parent.getContext().addRepository(panel.getRepository());
            } catch(MalformedURLException e1){
                JOptionPane.showMessageDialog(parent, e1.getLocalizedMessage(), "Input error", JOptionPane.WARNING_MESSAGE);
            }
        }
    }
}
