package jp.sourceforge.talisman.hermes.maven;
/*
 * $Id: Artifact.java 198 2009-05-30 14:45:26Z tama3 $
 */

import java.util.Iterator;

import jp.sourceforge.talisman.hermes.ResourceType;


/**
 * This class represents artifact of maven2.
 * 
 * @author Haruaki Tamada
 * @version $Revision: 198 $
 */
public class Artifact extends AbstractRepositoryItem{
    private static final long serialVersionUID = -2442342419534329093L;

    private String version;
    private ProjectObjectModel pom;
    private DependencyScope scope = DependencyScope.COMPILE;

    public Artifact(String groupId, String artifactId){
        super(groupId, artifactId);
    }

    public Artifact(String groupId, String artifactId, String version){
        super(groupId, artifactId);
        this.version = version;
    }

    public Artifact(String groupId, String artifactId, String version, DependencyScope scope){
        this(groupId, artifactId, version);
        this.scope = scope;
    }

    public String getVersion(){
        return version;
    }

    public void setVersion(String version){
        this.version = version;
    }

    public DependencyScope getScope(){
        return scope;
    }

    public void setScope(DependencyScope scope){
        this.scope = scope;
    }

    public synchronized ProjectObjectModel getPom(){
        if(pom == null){
            pom = new ProjectObjectModel(this);
        }
        return pom;
    }

    public boolean hasDependency(){
        return getPom().getDependencyCount() > 0;
    }

    public Iterator<Artifact> dependencies(){
        return getPom().iterator();
    }

    public Artifact[] getDependencies(){
        return getPom().getDependencies();
    }

    public boolean hasVersion(){
        return version != null;
    }

    public synchronized String getRelativePath(){
        return MavenPathUtils.getPath(getGroupId(), getArtifactId(), getVersion());
    }

    public String getFileName(){
        return getArtifactId() + "-" + version + "." + getType().getExtension(); 
    }

    public ResourceType getType(){
        return ResourceType.JAR;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(getGroupId()).append(":");
        sb.append(getArtifactId()).append(":");
        if(hasVersion()){
            sb.append(getVersion());
        }
        else{
            sb.append("???");
        }
        sb.append(" [").append(scope).append("]");
        return sb.toString();
    }

    public int hashCode(){
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getArtifactId() == null)? 0: getArtifactId().hashCode());
        result = prime * result + ((getGroupId() == null)? 0: getGroupId().hashCode());
        result = prime * result + ((getVersion() == null)? 0: getVersion().hashCode());
        result = prime * result * ((getPom() == null)? 0: getPom().hashCode());
        return result;
    }

    public boolean equals(Object o){
        if(o instanceof Artifact){
            Artifact a = (Artifact)o;
            boolean flag = true;
            if(getPom() != null){
                flag = getPom().equals(a.getPom());
            }
            else{
                flag = a.getPom() == null;
            }
            flag = flag && getGroupId().equals(a.getGroupId())
            && getArtifactId().equals(a.getArtifactId());
            if(getVersion() != null){
                flag = flag && getVersion().equals(a.getVersion());
            }
            else{
                flag = flag && a.getVersion() == null;
            }
            return flag && getScope() == a.getScope();
        }
        return false;
    }
}
