/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.hermes.maven;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.talisman.hermes.ResourceType;
import jp.sourceforge.talisman.hermes.Version;
import jp.sourceforge.talisman.hermes.maven.AbstractRepositoryItem;
import jp.sourceforge.talisman.hermes.maven.Artifact;
import jp.sourceforge.talisman.hermes.maven.MavenPathUtils;

public class Metadata
extends AbstractRepositoryItem
implements Iterable<String> {
    private static final long serialVersionUID = -7859414256240646632L;
    private List<String> versions = new ArrayList<String>();
    private String lastUpdated;
    private String latest;
    private transient Version latestVersion;

    public Metadata(Artifact artifact) {
        this(artifact.getGroupId(), artifact.getArtifactId());
    }

    public Metadata(String groupId, String artifactId) {
        super(groupId, artifactId);
    }

    public Metadata(Metadata metadata) {
        this(metadata.getGroupId(), metadata.getArtifactId());
        this.lastUpdated = metadata.getLastUpdated();
        this.latest = metadata.getLatestVersion();
        if (this.latest != null) {
            this.latestVersion = new Version(this.latest);
        }
        for (String v : metadata) {
            this.versions.add(v);
        }
    }

    @Override
    public ResourceType getType() {
        return ResourceType.XML;
    }

    public String getLatestVersion() {
        return this.latest;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public int getVersionCount() {
        return this.versions.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.versions.iterator();
    }

    public boolean contains(String version) {
        return this.versions.contains(version);
    }

    @Override
    public String getFileName() {
        return "maven-metadata.xml";
    }

    @Override
    public String getRelativePath() {
        return MavenPathUtils.getPath(this.getGroupId(), this.getArtifactId());
    }

    void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    void addVersion(String version) {
        Version v;
        this.versions.add(version);
        if (this.latest == null) {
            this.latest = version;
        }
        if (!(v = new Version(version)).isSnapshot()) {
            this.latestVersion = new Version(this.latest);
        }
        if (this.latestVersion != null && this.latestVersion.compareTo(v) < 0 && !v.isSnapshot()) {
            this.latest = version;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.latest != null) {
            this.latestVersion = new Version(this.latest);
        }
    }
}

