/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class DdlUtilsMojo
extends AbstractMojo {
    private File outputDirectory;
    private String platformType;
    private boolean dropTableFirst;
    private List files;

    public void execute() throws MojoExecutionException {
        if (this.platformType == null || this.platformType.length() < 1) {
            throw new MojoExecutionException("platformType is missing");
        }
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        Platform platform = PlatformFactory.createNewPlatformInstance((String)this.platformType);
        DatabaseIO dbio = new DatabaseIO();
        Iterator i = this.files.iterator();
        while (i.hasNext()) {
            File file = new File((String)i.next());
            Database database = dbio.read(file);
            String createTableDdl = platform.getCreateTablesSql(database, this.dropTableFirst, true);
            String name = file.getName();
            name = name.substring(0, name.lastIndexOf("."));
            File dest = new File(f, name + ".ddl");
            try {
                FileWriter out = new FileWriter(dest);
                out.write(createTableDdl);
                out.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
    }
}

