/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.csvio.builder;

import jp.sourceforge.talisman.csvio.CsvIOSetting;
import jp.sourceforge.talisman.csvio.CsvLineBuilder;
import jp.sourceforge.talisman.csvio.builder.AbstractCsvLineBuilder;
import jp.sourceforge.talisman.csvio.builder.NoQuoteCsvLineBuilder;
import jp.sourceforge.talisman.csvio.builder.QuoteAsNeededCsvLineBuilder;

public class CsvLineBuilderFactory {
    private static final CsvLineBuilderFactory factory = new CsvLineBuilderFactory();

    private CsvLineBuilderFactory() {
    }

    public static CsvLineBuilderFactory getInstance() {
        return factory;
    }

    public CsvLineBuilder createBuilder() {
        return this.createBuilder(new CsvIOSetting());
    }

    public CsvLineBuilder createBuilder(CsvIOSetting setting) {
        AbstractCsvLineBuilder builder = null;
        switch (setting.getQuotationMode()) {
            case ALWAYS: 
            case AS_NEEDED: {
                builder = new QuoteAsNeededCsvLineBuilder(setting);
                break;
            }
            case NEVER: {
                builder = new NoQuoteCsvLineBuilder(setting);
            }
        }
        return builder;
    }
}

